% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calf_wrappers.R
\name{calf_randomize}
\alias{calf_randomize}
\title{calf_randomize}
\usage{
calf_randomize(
  data,
  nMarkers,
  targetVector,
  times = 1,
  optimize = "pval",
  verbose = FALSE
)
}
\arguments{
\item{data}{Matrix or data frame. Must be binary data such that the first column must contain case/control dummy coded variable, as function is only approprite for binary data.}

\item{nMarkers}{Maximum number of markers to include in creation of sum.}

\item{targetVector}{Indicate "binary" for target vector with two options (e.g., case/control). Indicate "nonbinary" for target vector with real numbers.}

\item{times}{Numeric. Indicates the number of replications to run with randomization.}

\item{optimize}{Criteria to optimize if targetVector = "binary." Indicate "pval" to optimize the p-value corresponding to the t-test distinguishing case and control. Indicate "auc" to optimize the AUC.}

\item{verbose}{Logical. Indicate TRUE to print activity at each iteration to console. Defaults to FALSE.}
}
\value{
A data frame containing the chosen markers and their assigned weight (-1 or 1)

The optimal AUC, pval, or correlation for the classification.

aucHist A histogram of the AUCs across replications, if applicable.
}
\description{
Randomly selects from binary input provided to data parameter and runs Coarse Approximation Linear Function.
}
\examples{
calf_randomize(data = CaseControl, nMarkers = 6, targetVector = "binary", times = 5)
}
