#' Estimating population size via sample coverage
#' @param z the vector of capture histories or ascertainment records.
#' @return estimates based on any pair of samples

estN.pair4 <-
		function(z){
	z0001=z[1];	z0010=z[2]; z0011=z[3]; z0100=z[4]; z0101=z[5];
	z0110=z[6]; z0111=z[7]; z1000=z[8]; z1001=z[9]; z1010=z[10];
	z1011=z[11]; z1100=z[12]; z1101=z[13]; z1110=z[14]; z1111=z[15]
	
	n1=z1000+z1001+z1010+z1100+z1011+z1110+z1101+z1111
	n2=z0100+z0101+z0110+z0111+z1100+z1110+z1101+z1111
	n3=z0010+z0011+z0110+z0111+z1010+z1011+z1110+z1111
	n4=z0001+z0011+z0101+z0111+z1001+z1011+z1101+z1111
	
	M1=z1000+z1001+z1010+z1100+z1011+z1110+z1101+z1111+z0100+z0101+z0110+z0111
	M2=z1000+z1001+z1010+z1100+z1011+z1110+z1101+z1111+z0010+z0011+z0110+z0111
	M3=z1000+z1001+z1010+z1100+z1011+z1110+z1101+z1111+z0001+z0011+z0101+z0111
	M4=z0100+z0101+z0110+z0111+z1100+z1110+z1101+z1111+z0010+z0011+z1010+z1011
	M5=z0100+z0101+z0110+z0111+z1100+z1110+z1101+z1111+z0001+z0011+z1001+z1011
	M6=z0010+z0011+z0110+z0111+z1010+z1011+z1110+z1111+z0001+z0101+z1001+z1101
	
	#(1,2)
	pet1=(n1*n2)/(z1100+z1110+z1101+z1111)
	chp1=((n1+1)*(n2+1)/(z1100+z1110+z1101+z1111+1)-1)
	chse1=((n1+1)*(n2+1)*(z1000+z1001+z1010+z1011)*(z0100+z0101+z0110+z0111)/((z1100+z1110+z1101+z1111+1)^2*(z1100+z1110+z1101+z1111+2)))^.5
	ch1=exp(1.96*(log(1+chse1^2/(chp1-M1)^2))^(0.5))
	ch1l=M1+(chp1-M1)/ch1
	ch1u=M1+(chp1-M1)*ch1
	pa12=cbind(pet1,chp1,chse1,ch1l,ch1u)
	
	#(1,3)
	pet2=(n1*n3)/(z1010+z1110+z1011+z1111)
	chp2=((n1+1)*(n3+1)/(z1010+z1110+z1011+z1111+1)-1)
	chse2=((n1+1)*(n3+1)*(z1000+z1001+z1100+z1101)*(z0010+z0011+z0110+z0111)/((z1010+z1110+z1011+z1111+1)^2*(z1010+z1110+z1011+z1111+2)))^.5
	ch2=exp(1.96*(log(1+chse2^2/(chp2-M2)^2))^(0.5))
	ch2l=M2+(chp2-M2)/ch2
	ch2u=M2+(chp2-M2)*ch2
	pa13=cbind(pet2,chp2,chse2,ch2l,ch2u)
	
	#(1,4)
	pet3=(n1*n4)/(z1001+z1101+z1011+z1111)
	chp3=((n1+1)*(n4+1)/(z1001+z1101+z1011+z1111+1)-1)
	chse3=((n1+1)*(n4+1)*(z1000+z1010+z1100+z1110)*(z0001+z0011+z0101+z0111)/((z1001+z1101+z1011+z1111+1)^2*(z1001+z1101+z1011+z1111+2)))^.5
	ch3=exp(1.96*(log(1+chse3^2/(chp3-M3)^2))^(0.5))
	ch3l=M3+(chp3-M3)/ch3
	ch3u=M3+(chp3-M3)*ch3
	pa14=cbind(pet3,chp3,chse3,ch3l,ch3u)
	
	#(2,3)
	pet4=(n2*n3)/(z0110+z1110+z0111+z1111)
	chp4=((n2+1)*(n3+1)/(z0110+z1110+z0111+z1111+1)-1)
	chse4=((n2+1)*(n3+1)*(z0010+z0011+z1010+z1011)*(z0100+z0101+z1100+z1101)/((z0110+z1110+z0111+z1111+1)^2*(z0110+z1110+z0111+z1111+2)))^.5
	ch4=exp(1.96*(log(1+chse4^2/(chp4-M4)^2))^(0.5))
	ch4l=M4+(chp4-M4)/ch4
	ch4u=M4+(chp4-M4)*ch4
	pa23=cbind(pet4,chp4,chse4,ch4l,ch4u)
	
	#(2,4)
	pet5=(n2*n4)/(z0101+z1101+z0111+z1111)
	chp5=((n2+1)*(n4+1)/(z0101+z1101+z0111+z1111+1)-1)
	chse5=((n2+1)*(n4+1)*(z0001+z0011+z1001+z1011)*(z0100+z0110+z1100+z1110)/((z0101+z1101+z0111+z1111+1)^2*(z0101+z1101+z0111+z1111+2)))^.5
	ch5=exp(1.96*(log(1+chse5^2/(chp5-M5)^2))^(0.5))
	ch5l=M5+(chp5-M5)/ch5
	ch5u=M5+(chp5-M5)*ch5
	pa24=cbind(pet5,chp5,chse5,ch5l,ch5u)
	
	#(3,4)
	pet6=(n3*n4)/(z0011+z1011+z0111+z1111)
	chp6=((n3+1)*(n4+1)/(z0011+z1011+z0111+z1111+1)-1)
	chse6=((n3+1)*(n4+1)*(z0001+z0101+z1001+z1101)*(z0010+z0110+z1010+z1110)/((z0011+z1011+z0111+z1111+1)^2*(z0011+z1011+z0111+z1111+2)))^.5
	ch6=exp(1.96*(log(1+chse6^2/(chp6-M6)^2))^(0.5))
	ch6l=M6+(chp6-M6)/ch6
	ch6u=M6+(chp6-M6)*ch6
	pa34=cbind(pet6,chp6,chse6,ch6l,ch6u)
	
	pair=(rbind(pa12,pa13,pa14,pa23,pa24,pa34))
	colnames(pair)=c("Petersen","Chapman","se","cil","ciu")
	rownames(pair)=c("pa12","pa13","pa14","pa23","pa24","pa34")
	pair
}

