% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrot_functions.R
\name{regr_ind}
\alias{regr_ind}
\title{Indices of the best regressions}
\usage{
regr_ind(vari, outi, crv, cutoff = NULL, part = 10, mode, cmode = "det",
  predm = "exact", objfun = "acc", parallel = FALSE, cores)
}
\arguments{
\item{vari}{set of predictors}

\item{outi}{array of outcomes}

\item{crv}{number of cross-validations}

\item{cutoff}{cut-off value for mode \code{'binary'}}

\item{part}{for each cross-validation partitions the dataset into training and test set in a proportion \code{(part-1):part}}

\item{mode}{\code{'binary'} (logistic regression), \code{'multin'} (multinomial regression)}

\item{cmode}{\code{'det'} or \code{''}; \code{'det'} always predicts the more likely outcome as determined by the odds ratio; \code{''} predicts certain outcome with probability corresponding to its odds ratio (more conservative). Option available for multinomial/logistic regression}

\item{predm}{\code{'exact'} or \code{''}; for logistic and multinomial regression; \code{'exact'} computes how many times the exact outcome category was predicted, \code{''} computes how many times either the exact outcome category or its nearest neighbour was predicted}

\item{objfun}{\code{'roc'} for maximising the predictive power with respect to AUC, available only for \code{mode='binary'}; \code{'acc'} for maximising predictive power with respect to accuracy.}

\item{parallel}{TRUE if using parallel toolbox, FALSE if not. Defaults to FALSE}

\item{cores}{number of cores to use in case of parallel=TRUE}
}
\value{
Prints the best predictive power provided by a regression, predictive accuracy of the empirical prediction (value of \code{emp} computed by \code{cross_val} for logistic regression). Returns indices of the predictors included into regressions with the highest predictive power written in a list. For \code{mode='linear'} outputs a list of two lists. First list corresponds to the smallest absolute error, second corresponds to the smallest relative error
}
\description{
One of the two main functions of the package. Identifies the predictors included into regressions with the highest average predictive power
}
\examples{
#creating variables for linear regression mode

variables_lin<-matrix(c(rnorm(56,0,1),rnorm(56,1,2)),ncol=2)

#creating outcomes for linear regression mode

outcomes_lin<-rnorm(56,2,1)

#running the function

regr_ind(variables_lin,outcomes_lin,100,mode='linear',parallel=TRUE,cores=2)

#creating variables for binary mode

vari<-matrix(c(1:100,seq(1,300,3)),ncol=2)

#creating outcomes for binary mode

out<-rbinom(100,1,0.3)

#running the function

regr_ind(vari,out,100,cutoff=0.5,part=10,mode='binary',parallel=TRUE,cores=2)
}
\seealso{
Uses \code{\link{compute_weights}}, \code{\link{make_numeric}}, \code{\link{compute_max_weight}}, \code{\link{compute_weights}}, \code{\link{compute_max_length}}, \code{\link{cross_val}},\code{\link{av_out}}, \code{\link{get_indices}}
}
