% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDFtestingSuite.R
\name{Medians}
\alias{Medians}
\title{Retrieve a median estimate from the dpCDF}
\usage{
Medians(est, range, gran, ...)
}
\arguments{
\item{est}{The vector output of a differentially private CDF 
computation (cumulative count bins)}

\item{range}{A vector length 2 containing user-specified min and max to 
truncate the universe to}

\item{gran}{The smallest unit of measurement in the data (one [year]
for a list of ages),
the Domain (ie gran and range) should be identical to those used to 
create the CDF!}

\item{...}{Optionally add additional parameters. This is primarily used to allow automated
execution of varied diagnostic functions.}
}
\value{
A vector of medians obtained from a (differentially private) 
   CDF vector, not using any extra privacy budget,
   there may be more than one due to random noise causing the DPCDF doubling
   back over the .5 probablity latitude
}
\description{
Determines a median value from a CDF vector.
}
\examples{
Medians(c(.1,.2,.3,.3,.3,.3,.3,.3,.4,1),c(1,10), 1)
}

