% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{assert_tables}
\alias{assert_tables}
\alias{assertTables}
\title{Assert that tables exist in a cdm object}
\usage{
assert_tables(cdm, tables, empty.ok = FALSE, add = NULL)

assertTables(cdm, tables, empty.ok = FALSE, add = NULL)
}
\arguments{
\item{cdm}{A cdm object}

\item{tables}{A character vector of table names to check.}

\item{empty.ok}{Should an empty table (0 rows) be considered an error? TRUE or FALSE (default)}

\item{add}{An optional AssertCollection created by \code{checkmate::makeAssertCollection()} that errors should be added to.}
}
\value{
Invisibly returns the cdm object
}
\description{
A cdm object is a list of references to a subset of tables in the OMOP Common Data Model.
If you write a function that accepts a cdm object as a parameter \code{assert_tables}/\code{assertTables} will help you check
that the tables you need are in the cdm object, have the correct columns/fields, and (optionally) are not empty.
}
\section{Functions}{
\itemize{
\item \code{assertTables()}: camelCase alias

}}
\examples{
\dontrun{
# Use assertTables inside an analysis function to check that tables exist and are populated
countDrugsByGender <- function(cdm) {
  assertTables(cdm, tables = c("person", "drug_era"), empty.ok = FALSE)

  cdm$person \%>\%
    dplyr::inner_join(cdm$drug_era, by = "person_id") \%>\%
    dplyr::count(.data$gender_concept_id, .data$drug_concept_id) \%>\%
    dplyr::collect()
}

library(CDMConnector)
con <- DBI::dbConnect(duckdb::duckdb(), dbdir = eunomia_dir())
cdm <- cdm_from_con(con)

countDrugsByGender(cdm)

DBI::dbDisconnect(con, shutdown = TRUE)

}
}
