% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdm.R
\name{tbl_group}
\alias{tbl_group}
\alias{tblGroup}
\title{CDM table selection helper}
\usage{
tbl_group(group)

tblGroup(group)
}
\arguments{
\item{group}{A character vector of CDM table groups: "vocab", "clinical",
"all", "default", "derived".}
}
\value{
A character vector of CDM tables names in the groups
}
\description{
The OMOP CDM tables are grouped together and the \code{tbl_group} function allows
users to easily create a CDM reference including one or more table groups.
}
\details{
{\figure{cdm54.png}{options: width="100\%" alt="CDM 5.4"}}

The "default" table group is meant to capture the most commonly used set
of CDM tables. Currently the "default" group is: person,
observation_period, visit_occurrence,
visit_detail, condition_occurrence, drug_exposure, procedure_occurrence,
device_exposure, measurement, observation, death, note, note_nlp, specimen,
fact_relationship, location, care_site, provider, payer_plan_period,
cost, drug_era, dose_era, condition_era, concept, vocabulary,
concept_relationship, concept_ancestor, concept_synonym, drug_strength
}
\examples{
\dontrun{
con <- DBI::dbConnect(RPostgres::Postgres(),
                      dbname = "cdm",
                      host = "localhost",
                      user = "postgres",
                      password = Sys.getenv("PASSWORD"))

cdm <- cdm_from_con(con, cdm_tables = tbl_group("vocab"))
}
}
