% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdm.R
\name{cdm_from_con}
\alias{cdm_from_con}
\alias{cdmFromCon}
\title{Create a CDM reference object from a database connection}
\usage{
cdm_from_con(
  con,
  cdm_schema,
  write_schema,
  cohort_tables = NULL,
  cdm_version = "5.3",
  cdm_name = NULL,
  achilles_schema = NULL,
  .soft_validation = FALSE,
  write_prefix = NULL
)

cdmFromCon(
  con,
  cdmSchema,
  writeSchema,
  cohortTables = NULL,
  cdmVersion = "5.3",
  cdmName = NULL,
  achillesSchema = NULL,
  .softValidation = FALSE,
  writePrefix = NULL
)
}
\arguments{
\item{con}{A DBI database connection to a database where an OMOP CDM v5.4 or
v5.3 instance is located.}

\item{cdm_schema, cdmSchema}{The schema where the OMOP CDM tables are located. Defaults
to NULL.}

\item{write_schema, writeSchema}{An optional schema in the CDM database that the user has
write access to.}

\item{cohort_tables, cohortTables}{A character vector listing the cohort table names to be
included in the CDM object.}

\item{cdm_version, cdmVersion}{The version of the OMOP CDM: "5.3" (default), "5.4",
"auto". "auto" attempts to automatically determine the cdm version using
heuristics. Cohort tables must be in the write_schema.}

\item{cdm_name, cdmName}{The name of the CDM. If NULL (default) the cdm_source_name
.  field in the CDM_SOURCE table will be used.}

\item{achilles_schema, achillesSchema}{An optional schema in the CDM database
that contains achilles tables.}

\item{.soft_validation, .softValidation}{Normally the observation period table should not
have overlapping observation periods for a single person. If \code{.softValidation} is \code{TRUE} the
validation check that looks for overlapping observation periods will be skipped.
Other analytic packages may break or produce incorrect results if \code{softValidation} is \code{TRUE} and
the observation period table contains overlapping observation periods.}

\item{write_prefix, writePrefix}{A prefix that will be added to all tables created in the write_schema. This
can be used to create namespace in your database write_schema for your tables.}
}
\value{
A list of dplyr database table references pointing to CDM tables
}
\description{
Create a CDM reference object from a database connection
}
\details{
cdm_from_con / cdmFromCon creates a new cdm reference object from a DBI compliant database connection.
In addition to the connection the user needs to pass in the schema in the database where the cdm data can
be found as well as another schema where the user has write access to create tables. Nearly all
downstream analytic packages need the ability to create temporary data in the database so the
write_schema is required.

Some database systems have the idea of a catalog or a compound schema with two components.
See examples below for how to pass in catalogs and schemas.

You can also specify a \code{write_prefix}. This is a short character string that will be added
to any tables created in the \code{write_schema} effectively a namespace in the schema just for your
analysis. This makes it easy to ensure you do not overwrite someone elses tables if the write_schema is shared
and allows you to easily clean up tables by dropping all tables that start with the prefix.
The prefix is considered part of the write_schema since it is effectively a sub-schema. See examples.
}
\examples{
\dontrun{
library(CDMConnector)
con <- DBI::dbConnect(duckdb::duckdb(), eunomia_dir())

# minimal example
cdm <- cdm_from_con(con,
                    cdm_schema = "main",
                    write_schema = "scratch")

cdm <- cdm_from_con(con,
                    cdm_schema = "main",
                    write_schema = "scratch",
                    write_prefix = "tmp_")

# There are a few differen options for using catalogs
cdm <- cdm_from_con(con,
                    cdm_schema = "catalog.main",
                    write_schema = "catalog.scratch",
                    write_prefix = "tmp_")

cdm <- cdm_from_con(con,
                    cdm_schema = c(catalog = "catalog", schema = "main"),
                    write_schema = c(catalog = "catalog", schema = "scratch"))

cdm <- cdm_from_con(con,
                    cdm_schema = c("catalog", "main"),
                    write_schema = c("catalog", "scratch"))

cdm <- cdm_from_con(con,
                    cdm_schema = c(catalog = "catalog", schema = "main"),
                    write_schema = c(catalog = "catalog",
                                     schema = "scratch",
                                     prefix = "tmp_"))

 DBI::dbDisconnect(con)

}


}
