% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdm_from_environment.R
\name{cdmFromEnvironment}
\alias{cdmFromEnvironment}
\alias{cdm_from_environment}
\title{Create a CDM object from a pre-defined set of environment variables}
\usage{
cdmFromEnvironment(writePrefix = "")

cdm_from_environment(write_prefix = "")
}
\arguments{
\item{write_prefix, writePrefix}{(string) An optional prefix to use for all tables written to the CDM.}
}
\value{
A cdm_reference object
}
\description{
This function is intended to be used with the Darwin execution engine. The execution engine
runs OHDSI studies in a pre-defined runtime environment and makes several environment
variables available for connecting to a CDM database. Programmer writing code to run
on the execution engine and simply use \code{cdm <- cdmFromEnvironment()} to create a cdm reference
object to use for their analysis and the database connection and cdm object should be
automatically created. This obviates the need for site specific code for connecting
to the database and creating the cdm reference object.
}
\details{
The environment variables used by this function and provided by the execution engine are listed below.

\itemize{
\item{DBMS_TYPE: one of "postgresql", "sql server", "redshift", "duckdb", "snowflake".}
\item{DATA_SOURCE_NAME: a free text name for the CDM given by the person running the study.}
\item{CDM_VERSION: one of "5.3", "5.4".}
\item{DBMS_CATALOG: The database catalog. Important primarily for compound schema names used in SQL Server and Snowflake.}
\item{DBMS_SERVER: The database server URL.}
\item{DBMS_NAME: The database name used for creating the connection.}
\item{DBMS_PORT: The database port number.}
\item{DBMS_USERNAME: The database username needed to authenticate.}
\item{DBMS_PASSWORD: The database password needed to authenticate.}
\item{CDM_SCHEMA: The schema name where the OMOP CDM is located in the database.}
\item{WRITE_SCHEMA: The shema where the user has write access and tables will be created during study execution.}
}
}
\examples{
\dontrun{

library(CDMConnector)

# This will only work in an evironment where the proper variables are present.
cdm <- cdmFromEnvironment()

# Proceed with analysis using the cdm object.

# Close the database connection when done.
cdmDisconnect(cdm)
}
}
