% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Authentication.R
\name{GetOAuthClient}
\alias{GetOAuthClient}
\title{Get OAuth client}
\source{
\url{https://documentation.dataspace.copernicus.eu/APIs/SentinelHub/Overview/Authentication.html}
}
\usage{
GetOAuthClient(id, secret, url = getOption("CDSE.auth_url"))
}
\arguments{
\item{id}{character, user OAuth client id}

\item{secret}{character, user OAuth client secret}

\item{url}{character, endpoint for requesting tokens. Default: Copernicus Data Space Ecosystem OAuth endpoint}
}
\value{
\code{httr2} OAuth client object
}
\description{
Gets an OAuth authentication client (\code{httr2} OAuth client object)
}
\details{
The client can be used in queries requiring the authentication.
}
\examples{
\dontrun{
id <- "..."
secret <- "..."
OAuthClient <- GetOAuthClient(id = id, secret = secret)
}
}
\seealso{
\code{\link[CDSE]{GetOAuthToken}}
}
