% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetQueryables.R
\name{GetQueryables}
\alias{GetQueryables}
\title{Get CQL2 parameters for a collection}
\source{
\url{https://documentation.dataspace.copernicus.eu/APIs/SentinelHub/ApiReference.html#tag/catalog_collections/operation/getCatalogCollectionQueryables}
}
\usage{
GetQueryables(
  collection,
  as_data_frame = TRUE,
  client,
  token,
  url = getOption("CDSE.catalog_url")
)
}
\arguments{
\item{collection}{character indicating the collection for which the parameters are queried.
Must be one of the collections returned by \code{GetCollections}.}

\item{as_data_frame}{logical indicating if the result should be returned as data frame. Default: TRUE}

\item{client}{OAuth client object to use for authentication.}

\item{token}{OAuth token character string to use for authentication.

Exactly one of either \code{client} or \code{token} must be specified. It is recommended to use \code{client}.}

\item{url}{character indicating the STAC catalog search endpoint. Default: Copernicus Data Space Ecosystem STAC endpoint}
}
\value{
A \code{list} or a \code{data.frame}.
}
\description{
Returns a list of variable terms that can be used in CQL2 expressions to filter the collection catalog search.
}
\details{
If no parameters found, a \code{NULL} value or 0-row \code{data.frame} is returned.
}
\examples{
\dontrun{
GetQueryables("sentinel-2-l2a", client = OAuthClient)
}
}
\seealso{
\code{\link[CDSE]{GetCollections}}, \code{\link[CDSE]{SearchCatalog}}
}
