% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_fastcalcassist_fs.R
\name{CGGP_internal_calcpwanddpw}
\alias{CGGP_internal_calcpwanddpw}
\title{Calculate derivative of pw}
\usage{
CGGP_internal_calcpwanddpw(CGGP, y, theta, return_lS = FALSE)
}
\arguments{
\item{CGGP}{CGGP object}

\item{y}{Measured values for CGGP$design}

\item{theta}{Correlation parameters}

\item{return_lS}{Should lS and dlS be returned?}
}
\value{
derivative matrix of pw with respect to logtheta
}
\description{
Calculate derivative of pw
}
\examples{
cggp <- CGGPcreate(d=3, batchsize=100)
y <- apply(cggp$design, 1, function(x){x[1]+x[2]^2+rnorm(1,0,.01)})
CGGP_internal_calcpwanddpw(CGGP=cggp, y=y, theta=cggp$thetaMAP)
}
