% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_ancestors_and_relatives_of_samples.R
\name{find_ancestors_and_relatives_of_samples}
\alias{find_ancestors_and_relatives_of_samples}
\title{Find ancestors and relative of each sampled member of a pedigree}
\usage{
find_ancestors_and_relatives_of_samples(P, S, n)
}
\arguments{
\item{P}{a tibble that gives the pedigree.  It must have the columns \code{kid}, \code{pa}, \code{ma}.
These columns must be character vectors of the unique IDs for each individual in
the pedigree.
Every individual in the pedigree must appear exactly once in the \code{kid} column.  When founders
appear in the pedigree, their \code{pa} and \code{ma} entries must be "0" (i.e. character zero).}

\item{S}{a vector of the IDs of the sampled individuals.  Obviously, all members of S must appear
in P.}

\item{n}{number of generations back from the sampled individuals to return in each
individual's ancestor vector. 0 = self, 1 =  back to and including the parents,
2 = back to and including the grandparents, and so on.}
}
\value{
A tibble with three columns:
\itemize{
\item \code{sample_id}: the ID names of the sampled individuals
\item \code{ancestors}: a list column.  Each element is a vector of the ids of the ancestors of the
sampled individual in the 2^(n+1) - 1 positions.  The first is the sampled individual, the second
is pa, third is ma, fourth is pa's pa, fifth is pa's ma, sixth is ma's pa, and so forth.
\item \code{relatives}: a list column. Each element is a vector of the ids of the individuals that are \emph{sampled} relatives
within the n generations.  The first element is the sampled individual itself, and the remaining
ones are all the relatives of that individual whom were also sampled.
}
}
\description{
This is a fairly general function that can be applied to pedigree output
from any simulation program.  It calls a function written in C++ to
do all the recursive pedigree searching.
}
\examples{
# get some input variables
P <- three_pops_with_mig_slurped_results$pedigree
S <- three_pops_with_mig_slurped_results$samples$ID
n <- 2
result <- find_ancestors_and_relatives_of_samples(P, S, n)
result
}
\keyword{internal}
