% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_amm_from_matrix.R
\name{plot_amm_from_matrix}
\alias{plot_amm_from_matrix}
\title{plot an ancestry matrix (or multiple such matrices) from its (their) matrix form}
\usage{
plot_amm_from_matrix(X)
}
\arguments{
\item{X}{input tibble with a factor or character column \code{ID} that gives
the "name" of the ancestry matrix that will be used if you want to facet
over the values in \code{ID}. And also \code{X} must have a list column \code{anc_match_matrix} each
element of which is a logical ancestry match matrix.  \code{X} may have a list column
of tibbles called \code{psa_tibs} that says which cells are the primary shared ancestors.}
}
\value{
\code{plot_amm_from_matrix()} returns a ggplot object: each facet is an image of the
ancestry match matrix.  It is facet-wrapped over the values in the ID column of \code{X}.
}
\description{
For illustration purposes, if you want to simply plot an ancestry
matrix (or several) to show particular values, then this is the
handy function for you.
}
\examples{
# get some input: all the 2-generation AMMs in `example_amms`
X <- example_amms[stringr::str_detect(names(example_amms), "2gen$")] \%>\%
    tibble::enframe(name = "ID", value = "anc_match_matrix")

# plot those
g <- plot_amm_from_matrix(X) +
    ggplot2::facet_wrap(~ ID)

}
