% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncooked_spaghetti.R
\name{uncooked_spaghetti}
\alias{uncooked_spaghetti}
\title{Summarise kin-pair information and use it to create uncooked spaghetti plots}
\usage{
uncooked_spaghetti(Pairs, Samples, jitter_age = 0.2, jitter_year = 0.2)
}
\arguments{
\item{Pairs}{The tibble of kin pairs that comes out of \code{compile_related_pairs()}.}

\item{Samples}{The tibble of samples that comes out of \code{slurp_spip()}.}

\item{jitter_age}{half the width of the uniform jitter window around age}

\item{jitter_year}{half the width of the uniform jitter window around sampling year}
}
\value{
\code{uncooked_spaghetti()} returns a list with two components: \code{input_data} and \code{plot}.
\code{plot} is a ggplot object of the plot described above in "Description."  \code{input_data} is,
itself, another list with the following named components:
\itemize{
\item \code{P5}: A tibble that is a processed version of the \code{Pairs} input.  This is what
goes into making the ggplot.
\item \code{age_grid}: A tibble giving the coordinates for placing the alternating pink and white
horizontal background rectangles on the plot.
\item \code{year_grid}: A tibble giving the coordinates for placing the alternating pink and white
vertical background rectangles on the plot.
}
}
\description{
This gives a nice graphical summary of all the kin pairs along with when they
were sampled and their age at the time of sampling and their sex.
#'  In order to visually summarize all the kin pairs that were found,
with specific reference to their age, time of sampling, and sex, I find it
helpful to use what I have named the "Uncooked Spaghetti Plot".  There are multiple
subpanels on this plot.  Here is how to read/view these plots:
\itemize{
\item Each row of subpanels is for a different dominant relationship, going from
closer relationships near the top and more distant ones further down.  You can
find the abbreviation for the dominant relationship at the right edge of the panels.
\item In each row, there are four subpanels: \code{F->F}, \code{F->M}, \code{M->F}, and \code{M->M}.  These
refer to the different possible combinations of sexes of the individuals in the pair.
\itemize{
\item For the non-symmetrical relationships these are naturally defined with the
first letter (\code{F} for female or \code{M} for male) denoting the sex of the "upper_member"
of the relationship.  That is, if it is PO, then the sex of the parent is the first letter.
The sex of the non-upper-member is the second letter.  Thus a \code{PO} pair that consists of
a father and a daughter would appear in a plot that is in the \code{PO} row in the \code{M->F} column.
\item For the symmetrical relationships, there isn't a comparably natural way of
ordering the individuals' sexes for presentation.  For these relationships, the
first letter refers to the sex of the individual that was sampled in the earliest
year.  If both individuals were sampled in the same year, and they are of different
sexes, then the female is considered the first one, so those all go on the \code{F->M} subpanel.
}
\item On the subpanels, each straight line (i.e., each piece of uncooked spaghetti) represents
a single kin pair.  The two endpoints represent the year/time of sampling (on the x-axis)
and the age of the individual when it was sampled (on the y-axis) of the two members of
the pair.
\itemize{
\item If the relationship is non-symmetrical, then the line is drawn as an arrow pointing
from the upper member to the lower member.
\item The color of the line gives the number of shared ancestors (\code{max_hit}) at the level
of the dominant relationship. This is how you can distinguish full-sibs from half-sibs, etc.
}
}
}
\examples{
# get the input variables
# only take the first 50 samples to reduce time for example
Samples <- species_1_slurped_results$samples[1:50, ]
Pairs <- compile_related_pairs(Samples)
result <- uncooked_spaghetti(Pairs, Samples)

# produce the plot with:
# result$plot
}
