% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_interface_predict_clvfittedspending.R
\name{predict.clv.fitted.spending}
\alias{predict.clv.fitted.spending}
\alias{predict,clv.fitted.spending-method}
\title{Predict customers' future spending}
\usage{
\method{predict}{clv.fitted.spending}(
  object,
  newdata = NULL,
  uncertainty = c("none", "boots"),
  level = 0.9,
  num.boots = 100,
  verbose = TRUE,
  ...
)

\S4method{predict}{clv.fitted.spending}(
  object,
  newdata = NULL,
  uncertainty = c("none", "boots"),
  level = 0.9,
  num.boots = 100,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A fitted spending model for which prediction is desired.}

\item{newdata}{A clv data object for which predictions should be made with the fitted model. If none or NULL is given, predictions are made for the data on which the model was fit.}

\item{uncertainty}{Method to produce confidence intervals of the predictions (parameter uncertainty). Either "none" (default) or "boots".}

\item{level}{Required confidence level, if \code{uncertainty="boots"}.}

\item{num.boots}{Number of bootstrap repetitions, if \code{uncertainty="boots"}. A low number may not produce intervals for all customers if they are not sampled.}

\item{verbose}{Show details about the running of the function.}

\item{...}{Ignored}
}
\value{
An object of class \code{data.table} with columns:
\item{Id}{The respective customer identifier}
\item{actual.mean.spending}{Actual mean spending per transaction in the holdout period. Only if there is a holdout period otherwise it is not reported.}
\item{predicted.mean.spending}{The mean spending per transaction as predicted by the fitted spending model.}
}
\description{
Predict customer's future mean spending per transaction and compare it to the actual mean spending in the holdout period.
}
\details{
If \code{newdata} is provided, the individual customer statistics underlying the model are calculated
the same way as when the model was fit initially. Hence, if \code{remove.first.transaction} was \code{TRUE},
this will be applied to \code{newdata} as well.
}
\examples{
\donttest{
data("apparelTrans")

# Fit gg model on data
apparel.holdout <- clvdata(apparelTrans, time.unit="w",
                           estimation.split=37, date.format="ymd")
apparel.gg <- gg(apparel.holdout)

# Predict customers' future mean spending per transaction
predict(apparel.gg)

}

}
\seealso{
models to predict spending: \link{gg}.

models to predict transactions: \link{pnbd}, \link{bgnbd}, \link{ggomnbd}.

\code{\link[CLVTools:predict.clv.fitted.transactions]{predict}} for transaction models
}
