% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rebinGenomicInteractions.R
\name{rebinGenomicInteractions}
\alias{rebinGenomicInteractions}
\title{Assign GenomicInteractions to a predefined series of bins for row and column, corresponding to a genomic matrix.}
\arguments{
\item{gint}{A GenomicInteractions object needing to be binned.}

\item{whole_genome_matrix}{A matrix with underscored positions for column and rownames e.g. chr1_1_5000,chr1_5001_10000.  If this is provided, it will override rown/column names and GRanges objects.}

\item{rownames_gr}{A Genomic Ranges object created from the whole genome matrix row names in chr_start_end format, e.g. chr1_1_5000. No effect if whole_genome_mattrix is specified.}

\item{colnames_gr}{A Genomic Ranges object created from the whole genome matrix column names in chr_start_end format. No effect if whole_genome_mattrix is specified.}

\item{rownames_mat}{The row names of the whole_genome_matrix in chr_start_end format.}

\item{colnames_mat}{The column names of the whole_genome_matrix in chr_start_end format.}

\item{method}{Method to rebin with-- can use overlap and nearest methods.Default: nearest.}
}
\description{
This function allows the user to assign a set of genomicinteractions to a pre-existing matrix with known dimensions and column/row names. It finds the row/column index of each point and produces a merged dataframe with the original annotation columns that correspond to each bin in the matrix, with appropriate labels & indexes.
}
\examples{
foreach::registerDoSEQ()
gint_small_chr1<-importBreakpointBed(breakpoint_fn = system.file("extdata",
"sample_breakpoints_chr1.bed",package = "CNVScope"))
load(system.file("extdata","nbl_result_matrix_sign_small.rda",package = "CNVScope")) 
rebinGenomicInteractions(gint=gint_small_chr1,whole_genome_matrix=NULL,
rownames_gr=underscored_pos_to_GRanges(rownames(nbl_result_matrix_sign_small)),
colnames_gr=underscored_pos_to_GRanges(colnames(nbl_result_matrix_sign_small)),
rownames_mat = rownames(nbl_result_matrix_sign_small),
colnames_mat = colnames(nbl_result_matrix_sign_small),
method="nearest")
}
\keyword{GenomicInteractions}
\keyword{bin}
\keyword{binning}
\keyword{colnames}
\keyword{matrix}
\keyword{rownames}
