% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_compare.R
\name{compTable}
\alias{compTable}
\title{Rank comparison table between two COINs}
\usage{
compTable(
  COIN1,
  COIN2,
  dset = "Raw",
  isel,
  COINnames = NULL,
  sort_by = "AbsRankChange"
)
}
\arguments{
\item{COIN1}{First COIN}

\item{COIN2}{Second COIN}

\item{dset}{The data set of interest}

\item{isel}{The indicator/column of interest}

\item{COINnames}{An optional character vector of the names of \code{COIN1} and \code{COIN2}, to be used in the table headers.}

\item{sort_by}{If \code{"RankCOIN1"}, sorts by the indicator values of COIN1, if \code{"RankCOIN2"}, sorts by \code{COIN2},
if \code{"RankChange"}, sorts by rank change, and if \code{"AbsRankChange"} sorts by absolute rank change.}
}
\value{
A data frame with ranks and rank changes between two COINs.
}
\description{
Takes two COINs, and generates a rank comparison between specified indicator/aggregates. COINs must share at least some common
unit codes, and the indicator selected by \code{isel}.
}
\examples{
ASEM <- build_ASEM()
# Make a copy
ASEMAltNorm <- ASEM
# Edit .$Method
ASEMAltNorm$Method$normalise$ntype <- "borda"
# Regenerate
ASEMAltNorm <- regen(ASEMAltNorm, quietly = TRUE)
# compare
CT <- compTable(ASEM, ASEMAltNorm, dset = "Aggregated", isel = "Index")

}
\seealso{
\itemize{
\item \code{\link[=compTableMulti]{compTableMulti()}} Comparison table between multiple COINs
}
}
