% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locFDR_BF_theoretic.R
\name{analytic_locFDR_BF_cor}
\alias{analytic_locFDR_BF_cor}
\title{Analytic calculation of the local FDR & Bayes factor for correlated summary statistics.}
\usage{
analytic_locFDR_BF_cor(BetaHat, SE, Corln, SpikeVar = 1e-04, SlabVar = 0.8)
}
\arguments{
\item{BetaHat}{A numeric vector of length K where K is the number of phenotypes. It
contains the beta-hat values across studies/traits. No default.}

\item{SE}{A numeric vector with the same dimension as BetaHat providing the standard errors
corresponding to BetaHat. Every element of SE must be positive. No default.}

\item{Corln}{A numeric square matrix of order K by K providing the correlation matrix of BetaHat.
The number of rows & columns of Corln must be the same as the length of BetaHat. No default
 is specified. See \code{\link{estimate_corln}}.}

\item{SpikeVar}{Variance of spike (normal distribution with small variance) representing the null effect distribution.
Default is 10^(-4).}

\item{SlabVar}{Variance of slab normal distribution representing the non-null effect distribution.
Default is 0.8.}
}
\value{
The output produced by the function is a list which consists of the local FDR and log10(Bayes factor).
   \item{locFDR}{It provides the analytically computed local false discovery rate (posterior probability of null association) under CPBayes model
    (a Bayesian analog of the p-value) which is a measure of the evidence of the
    aggregate-level pleiotropic association. Bayes factor is adjusted for prior odds, but
     locFDR is solely a function of the posterior odds.}
   \item{log10_BF}{It provides the analytically computed log10(Bayes factor) produced by CPBayes that measures the
    evidence of the overall pleiotropic association.}
}
\description{
Run the \code{\link{analytic_locFDR_BF_cor}} function to analytically compute the local FDR & Bayes factor (BF)
that quantifies the evidence of aggregate-level pleiotropic association for correlated summary statistics.
Here a fixed value of slab variance is considred instead of a range of it in \code{\link{cpbayes_cor}}.
}
\examples{
data(ExampleDataCor)
BetaHat <- ExampleDataCor$BetaHat
BetaHat
SE <- ExampleDataCor$SE
SE
cor <- ExampleDataCor$cor
cor
result <- cpbayes_cor(BetaHat, SE, cor)
str(result)

}
\references{
Majumdar A, Haldar T, Bhattacharya S, Witte JS (2018) An efficient Bayesian meta analysis approach for studying cross-phenotype genetic associations. PLoS Genet 14(2): e1007139.
}
\seealso{
\code{\link{cpbayes_cor}}, \code{\link{estimate_corln}}, \code{\link{analytic_locFDR_BF_uncor}}, \code{\link{cpbayes_uncor}}, \code{\link{post_summaries}}, \code{\link{forest_cpbayes}}
}
