% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotForecastPDF.R
\name{PlotForecastPDF}
\alias{PlotForecastPDF}
\title{Plot one or multiple ensemble forecast pdfs for the same event}
\usage{
PlotForecastPDF(
  fcst,
  tercile.limits,
  extreme.limits = NULL,
  obs = NULL,
  plotfile = NULL,
  title = "Set a title",
  var.name = "Varname (units)",
  fcst.names = NULL,
  add.ensmemb = c("above", "below", "no"),
  color.set = c("ggplot", "s2s4e", "hydro"),
  memb_dim = "member"
)
}
\arguments{
\item{fcst}{A dataframe or array containing all the ensember members for each 
forecast. If \code{'fcst'} is an array, it should have two labelled 
dimensions, and one of them should be \code{'members'}. If \code{'fcsts'} is 
a data.frame, each column shoul be a separate forecast, with the rows beeing 
the different ensemble members.}

\item{tercile.limits}{An array or vector with P33 and P66 values that define 
the tercile categories for each panel. Use an array of dimensions 
(nforecasts,2) to  define different terciles for each forecast panel, or a 
vector with two elements to reuse the same tercile limits for all forecast 
panels.}

\item{extreme.limits}{(optional) An array or vector with P10 and P90 values 
that define the extreme categories for each panel. Use an array of 
(nforecasts,2) to define different extreme limits for each forecast panel, 
or a vector with two elements to reuse the same tercile limits for all 
forecast panels. (Default: extreme categories are not shown).}

\item{obs}{(optional) A vector providing the observed values for each forecast 
panel or a single value that will be reused for all forecast panels. 
(Default: observation is not shown).}

\item{plotfile}{(optional) A filename (pdf, png...) where the plot will be 
saved. (Default: the plot is not saved).}

\item{title}{A string with the plot title.}

\item{var.name}{A string with the variable name and units.}

\item{fcst.names}{(optional) An array of strings with the titles of each 
individual forecast.}

\item{add.ensmemb}{Either to add the ensemble members \code{'above'} (default) 
or \code{'below'} the pdf, or not (\code{'no'}).}

\item{color.set}{A selection of predefined color sets: use \code{'ggplot'} 
(default) for blue/green/red, \code{'s2s4e'} for blue/grey/orange, or 
\code{'hydro'} for yellow/gray/blue (suitable for precipitation and 
inflows).}

\item{memb_dim}{A character string indicating the name of the member 
dimension.}
}
\value{
A ggplot object containing the plot.
}
\description{
This function plots the probability distribution function of 
several ensemble forecasts. Separate panels are used to plot forecasts valid 
or initialized at different times or by different models or even at different 
locations. Probabilities for tercile categories are computed, plotted in 
colors and annotated. An asterisk marks the tercile with higher probabilities. 
Probabilities for extreme categories (above P90 and below P10) can also be 
included as hatched areas. Individual ensemble members can be plotted as 
jittered points. The observed value is optionally shown as a diamond.
}
\examples{
fcsts <- data.frame(fcst1 = rnorm(10), fcst2 = rnorm(10, 0.5, 1.2), 
                   fcst3 = rnorm(10, -0.5, 0.9))
PlotForecastPDF(fcsts,c(-1,1))
\donttest{
fcsts2 <- array(rnorm(100), dim = c(member = 20, fcst = 5))
PlotForecastPDF(fcsts2, c(-0.66, 0.66), extreme.limits = c(-1.2, 1.2), 
               fcst.names = paste0('random fcst ', 1 : 5), obs = 0.7)
}
}
\author{
Llorenç Lledó \email{llledo@bsc.es}
}
