% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cub00.R
\name{cub00}
\alias{cub00}
\title{Main function for CUB models without covariates}
\usage{
cub00(m, ordinal, maxiter, toler, makeplot,summary)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm}

\item{toler}{Fixed error tolerance for final estimates}

\item{makeplot}{Logical: if TRUE, the function returns a graphical plot comparing fitted probabilities 
and observed relative frequencies}

\item{summary}{Logical: if TRUE, summary results of the fitting procedure are displayed on screen}
}
\value{
An object of the class "CUB"
}
\description{
Function to estimate and validate a CUB model without covariates for given ordinal responses.
}
\examples{
#Running donttest option since the proposed examples require a long time run for check 
\donttest{
data(univer)
m=7
ordinal=univer[,12]
model=cub00(m, ordinal, maxiter=500, toler=1e-6, makeplot=TRUE,summary=TRUE)
parest=model$estimates  #ML estimates (pai,csi)
maxlik=model$loglik
nniter=model$niter
vmat=model$varmat
BICCUB=model$BIC
#############################
informat=univer[,8]
model=cub00(m,informat,maxiter=500,toler=1e-6,makeplot=FALSE,summary=FALSE)
parest=model$estimates   #ML estimates (pai,csi)
maxlik=model$loglik
nniter=model$niter
vmat=model$varmat
BICCUB=model$BIC
}
}
\seealso{
\code{\link{CUB}}, \code{\link{probbit}}, \code{\link{probcub00}}, \code{\link{loglikCUB}}
}
\keyword{internal}

