% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver.R
\docType{class}
\name{SCS-class}
\alias{SCS-class}
\alias{SCS}
\alias{SCS}
\alias{lp_capable,SCS-method}
\alias{socp_capable,SCS-method}
\alias{sdp_capable,SCS-method}
\alias{exp_capable,SCS-method}
\alias{mip_capable,SCS-method}
\alias{name,SCS-method}
\alias{import_solver,SCS-method}
\alias{Solver.solve,SCS-method}
\alias{format_results,SCS-method}
\title{The SCS class.}
\usage{
SCS()

\S4method{lp_capable}{SCS}(solver)

\S4method{socp_capable}{SCS}(solver)

\S4method{sdp_capable}{SCS}(solver)

\S4method{exp_capable}{SCS}(solver)

\S4method{mip_capable}{SCS}(solver)

\S4method{name}{SCS}(object)

\S4method{import_solver}{SCS}(solver)

\S4method{Solver.solve}{SCS}(solver, objective, constraints, cached_data,
  warm_start, verbose, ...)

\S4method{format_results}{SCS}(solver, results_dict, data, cached_data)
}
\arguments{
\item{object, solver}{A \linkS4class{SCS} object.}

\item{objective}{A list representing the canonicalized objective.}

\item{constraints}{A list of canonicalized constraints.}

\item{cached_data}{A list mapping solver name to cached problem data.}

\item{warm_start}{A logical value indicating whether the previous solver result should be used to warm start.}

\item{verbose}{A logical value indicating whether to print solver output.}

\item{...}{Additional arguments to the solver.}

\item{results_dict}{A list containing the solver output.}

\item{data}{A list containing information about the problem.}
}
\description{
This class is an interface for the SCS solver.
}
\section{Methods (by generic)}{
\itemize{
\item \code{lp_capable}: SCS can handle linear programs.

\item \code{socp_capable}: SCS can handle second-order cone programs.

\item \code{sdp_capable}: SCS can handle semidefinite programs.

\item \code{exp_capable}: SCS can handle exponential cone programs.

\item \code{mip_capable}: SCS cannot handle mixed-integer programs.

\item \code{name}: The name of the solver.

\item \code{import_solver}: Imports the scs library.

\item \code{Solver.solve}: Call the solver on the canonicalized problem.

\item \code{format_results}: Convert raw solver output into standard list of results.
}}

\examples{
scs <- SCS()
lp_capable(scs)
sdp_capable(scs)
socp_capable(scs)
exp_capable(scs)
mip_capable(scs)
}
\references{
B. O'Donoghue, E. Chu, N. Parikh, and S. Boyd. "Conic Optimization via Operator Splitting and Homogeneous Self-Dual Embedding." \emph{Journal of Optimization Theory and Applications}, pp. 1-27, 2016. \url{https://doi.org/10.1007/s10957-016-0892-3}.
}
\seealso{
\code{\link[scs]{scs}} and the \href{https://github.com/cvxgrp/scs}{SCS Github}.
}
