% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementwise.R
\docType{class}
\name{Power-class}
\alias{Power-class}
\alias{.Power}
\alias{Power}
\alias{validate_args,Power-method}
\alias{get_data,Power-method}
\alias{to_numeric,Power-method}
\alias{sign_from_args,Power-method}
\alias{is_atom_convex,Power-method}
\alias{is_atom_concave,Power-method}
\alias{is_constant,Power-method}
\alias{is_incr,Power-method}
\alias{is_decr,Power-method}
\alias{is_quadratic,Power-method}
\alias{graph_implementation,Power-method}
\title{The Power class.}
\usage{
Power(x, p, max_denom = 1024)

\S4method{validate_args}{Power}(object)

\S4method{get_data}{Power}(object)

\S4method{to_numeric}{Power}(object, values)

\S4method{sign_from_args}{Power}(object)

\S4method{is_atom_convex}{Power}(object)

\S4method{is_atom_concave}{Power}(object)

\S4method{is_constant}{Power}(object)

\S4method{is_incr}{Power}(object, idx)

\S4method{is_decr}{Power}(object, idx)

\S4method{is_quadratic}{Power}(object)

\S4method{graph_implementation}{Power}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{x}{The \linkS4class{Expression} to be raised to a power.}

\item{p}{A numeric value indicating the scalar power.}

\item{max_denom}{The maximum denominator considered in forming a rational approximation of \code{p}.}

\item{object}{A \linkS4class{Power} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the elementwise power function \eqn{f(x) = x^p}.
If \code{expr} is a CVXR expression, then \code{expr^p} is equivalent to \code{Power(expr, p)}.
}
\details{
#' For \eqn{p = 0}, \eqn{f(x) = 1}, constant, positive.
For \eqn{p = 1}, \eqn{f(x) = x}, affine, increasing, same sign as \eqn{x}.
For \eqn{p = 2,4,8,...}, \eqn{f(x) = |x|^p}, convex, signed monotonicity, positive.
For \eqn{p < 0} and \eqn{f(x) = }
\itemize{
  \item{\eqn{x^p}}{ for \eqn{x > 0}}
  \item{\eqn{+\infty}}{\eqn{x \leq 0}}
}, this function is convex, decreasing, and positive.
For \eqn{0 < p < 1} and \eqn{f(x) =}
\itemize{
  \item{\eqn{x^p}}{ for \eqn{x \geq 0}}
  \item{\eqn{-\infty}}{\eqn{x < 0}}
}, this function is concave, increasing, and positive.
For \eqn{p > 1, p \neq 2,4,8,\ldots} and \eqn{f(x) = }
\itemize{
  \item{\eqn{x^p}}{ for \eqn{x \geq 0}}
  \item{\eqn{+\infty}}{\eqn{x < 0}}
}, this function is convex, increasing, and positive.
}
\section{Methods (by generic)}{
\itemize{
\item \code{validate_args}: Verification of arguments happens during initialization.

\item \code{get_data}: A list containing the output of \code{pow_low, pow_mid}, or \code{pow_high} depending on the input power.

\item \code{to_numeric}: Throw an error if the power is negative and cannot be handled.

\item \code{sign_from_args}: The sign of the atom.

\item \code{is_atom_convex}: Is \eqn{p \leq 0} or \eqn{p \geq 1}?

\item \code{is_atom_concave}: Is \eqn{p \geq 0} or \eqn{p \leq 1}?

\item \code{is_constant}: A logical value indicating whether the atom is constant.

\item \code{is_incr}: A logical value indicating whether the atom is weakly increasing.

\item \code{is_decr}: A logical value indicating whether the atom is weakly decreasing.

\item \code{is_quadratic}: A logical value indicating whether the atom is quadratic.

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{x}}{The \linkS4class{Expression} to be raised to a power.}

\item{\code{p}}{A numeric value indicating the scalar power.}

\item{\code{max_denom}}{The maximum denominator considered in forming a rational approximation of \code{p}.}
}}

