% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affine.R
\docType{class}
\name{Conv-class}
\alias{Conv-class}
\alias{.Conv}
\alias{Conv}
\alias{to_numeric,Conv-method}
\alias{validate_args,Conv-method}
\alias{dim_from_args,Conv-method}
\alias{sign_from_args,Conv-method}
\alias{is_incr,Conv-method}
\alias{is_decr,Conv-method}
\alias{graph_implementation,Conv-method}
\title{The Conv class.}
\usage{
Conv(lh_exp, rh_exp)

\S4method{to_numeric}{Conv}(object, values)

\S4method{validate_args}{Conv}(object)

\S4method{dim_from_args}{Conv}(object)

\S4method{sign_from_args}{Conv}(object)

\S4method{is_incr}{Conv}(object, idx)

\S4method{is_decr}{Conv}(object, idx)

\S4method{graph_implementation}{Conv}(object, arg_objs, dim, data = NA_real_)
}
\arguments{
\item{lh_exp}{An \linkS4class{Expression} or R numeric data representing the left-hand vector.}

\item{rh_exp}{An \linkS4class{Expression} or R numeric data representing the right-hand vector.}

\item{object}{A \linkS4class{Conv} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{dim}{A vector representing the dimensions of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the 1-D discrete convolution of two vectors.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric(Conv)}: The convolution of the two values.

\item \code{validate_args(Conv)}: Check both arguments are vectors and the first is a constant.

\item \code{dim_from_args(Conv)}: The dimensions of the atom.

\item \code{sign_from_args(Conv)}: The sign of the atom.

\item \code{is_incr(Conv)}: Is the left-hand expression positive?

\item \code{is_decr(Conv)}: Is the left-hand expression negative?

\item \code{graph_implementation(Conv)}: The graph implementation of the atom.

}}
\section{Slots}{

\describe{
\item{\code{lh_exp}}{An \linkS4class{Expression} or R numeric data representing the left-hand vector.}

\item{\code{rh_exp}}{An \linkS4class{Expression} or R numeric data representing the right-hand vector.}
}}

