% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constant.R
\docType{class}
\name{Constant-class}
\alias{Constant-class}
\alias{.Constant}
\alias{Constant}
\alias{show,Constant-method}
\alias{name,Constant-method}
\alias{constants,Constant-method}
\alias{value,Constant-method}
\alias{is_pos,Constant-method}
\alias{grad,Constant-method}
\alias{dim,Constant-method}
\alias{canonicalize,Constant-method}
\alias{is_nonneg,Constant-method}
\alias{is_nonpos,Constant-method}
\alias{is_imag,Constant-method}
\alias{is_complex,Constant-method}
\alias{is_symmetric,Constant-method}
\alias{is_hermitian,Constant-method}
\alias{is_psd,Constant-method}
\alias{is_nsd,Constant-method}
\alias{as.Constant}
\title{The Constant class.}
\usage{
Constant(value)

\S4method{show}{Constant}(object)

\S4method{name}{Constant}(x)

\S4method{constants}{Constant}(object)

\S4method{value}{Constant}(object)

\S4method{is_pos}{Constant}(object)

\S4method{grad}{Constant}(object)

\S4method{dim}{Constant}(x)

\S4method{canonicalize}{Constant}(object)

\S4method{is_nonneg}{Constant}(object)

\S4method{is_nonpos}{Constant}(object)

\S4method{is_imag}{Constant}(object)

\S4method{is_complex}{Constant}(object)

\S4method{is_symmetric}{Constant}(object)

\S4method{is_hermitian}{Constant}(object)

\S4method{is_psd}{Constant}(object)

\S4method{is_nsd}{Constant}(object)

as.Constant(expr)
}
\arguments{
\item{value}{A numeric element, vector, matrix, or data.frame. Vectors are automatically cast into a matrix column.}

\item{x, object}{A \linkS4class{Constant} object.}

\item{expr}{An \linkS4class{Expression}, numeric element, vector, matrix, or data.frame.}
}
\value{
A \linkS4class{Constant} representing the input as a constant.
}
\description{
This class represents a constant.

Coerce an R object or expression into the \linkS4class{Constant} class.
}
\section{Methods (by generic)}{
\itemize{
\item \code{name(Constant)}: The name of the constant.

\item \code{constants(Constant)}: Returns itself as a constant.

\item \code{value(Constant)}: The value of the constant.

\item \code{is_pos(Constant)}: A logical value indicating whether all elements of the constant are positive.

\item \code{grad(Constant)}: An empty list since the gradient of a constant is zero.

\item \code{dim(Constant)}: The \code{c(row, col)} dimensions of the constant.

\item \code{canonicalize(Constant)}: The canonical form of the constant.

\item \code{is_nonneg(Constant)}: A logical value indicating whether all elements of the constant are non-negative.

\item \code{is_nonpos(Constant)}: A logical value indicating whether all elements of the constant are non-positive.

\item \code{is_imag(Constant)}: A logical value indicating whether the constant is imaginary.

\item \code{is_complex(Constant)}: A logical value indicating whether the constant is complex-valued.

\item \code{is_symmetric(Constant)}: A logical value indicating whether the constant is symmetric.

\item \code{is_hermitian(Constant)}: A logical value indicating whether the constant is a Hermitian matrix.

\item \code{is_psd(Constant)}: A logical value indicating whether the constant is a positive semidefinite matrix.

\item \code{is_nsd(Constant)}: A logical value indicating whether the constant is a negative semidefinite matrix.

}}
\section{Slots}{

\describe{
\item{\code{value}}{A numeric element, vector, matrix, or data.frame. Vectors are automatically cast into a matrix column.}

\item{\code{sparse}}{(Internal) A logical value indicating whether the value is a sparse matrix.}

\item{\code{is_pos}}{(Internal) A logical value indicating whether all elements are non-negative.}

\item{\code{is_neg}}{(Internal) A logical value indicating whether all elements are non-positive.}
}}

\examples{
x <- Constant(5)
y <- Constant(diag(3))
get_data(y)
value(y)
is_nonneg(y)
size(y)
as.Constant(y)
}
