% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{prediction}
\alias{prediction}
\title{Generates \code{\link{prediction.class}} objects}
\usage{
prediction(modelfit, x.new)
}
\arguments{
\item{modelfit}{a \code{\link{calibrate.class}} object}

\item{x.new}{newdata for the prediction}
}
\value{
return a \code{\link{prediction.class}} object with two main methods
}
\description{
\code{prediction} is a function that allows us to generate a class in which the estimation is
done
}
\details{
The realized estimation is realized similarly as it is defined in [1]
}
\examples{
\dontrun{
###################### The code to calibrate
X <- cbind(seq(0,1,length.out=10),seq(0,1,length.out=10))
code <- function(X,theta)
{
  return((6*X[,1]*theta[2]-2)^2*theta[1]*sin(theta[3]*X[,2]-4))
}
Yexp <- code(X,c(1,1,11))+rnorm(10,0,0.1)

############### For the first model
###### Definition of the model
md <- model(code,X,Yexp,"model1")
###### Definition of the prior densities
pr <- prior(type.prior=c("gaussian","gaussian","gaussian","gamma"),opt.prior=
list(c(1,0.01),c(1,0.01),c(11,3),c(2,0.1)))
###### Definition of the calibration options
opt.estim=list(Ngibbs=200,Nmh=600,thetaInit=c(1,1,11,0.1),k=c(6e-3,1e-3,1e-5,1e-3),
sig=diag(4),Nchains=1,burnIn=100)
###### Run the calibration
mdfit <- calibrate(md,pr,opt.estim)
###### Prediction between 1 and 1.2
X.new <- cbind(seq(1,1.2,length.out=10),seq(1,1.2,length.out=10))
pr <- prediction(mdfit,X.new)
print(pr)
plot(pr,select.X=X[,1])
}
}
\seealso{
\code{\link{model.class}}, \code{\link{prior.class}}
}
\author{
M. Carmassi
}
