% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{heartdisease_tbl_df}
\alias{heartdisease_tbl_df}
\title{Heart Disease Patients Clinical Data}
\format{
A tibble with 303 observations and 9 variables:
\describe{
  \item{Age}{Age of the individual (numeric).}
  \item{Sex}{Sex of the individual (factor with 2 levels: typically "Male" and "Female").}
  \item{ChestPain}{Type of chest pain experienced (factor with 4 levels).}
  \item{BP}{Resting blood pressure (numeric).}
  \item{Cholesterol}{Serum cholesterol in mg/dl (numeric).}
  \item{BloodSugar}{Indicates if fasting blood sugar > 120 mg/dl (logical).}
  \item{MaximumHR}{Maximum heart rate achieved (numeric).}
  \item{ExerciseInducedAngina}{Exercise-induced angina (factor with 2 levels).}
  \item{HeartDisease}{Presence or absence of heart disease (factor with 2 levels).}
}
}
\source{
Data taken from the cheese package version 0.1.2. Original source:
UCI Machine Learning Repository. Heart Disease Data Set.
\url{https://archive.ics.uci.edu/ml/datasets/Heart+Disease}
}
\usage{
data(heartdisease_tbl_df)
}
\description{
This dataset, heartdisease_tbl_df, is a tibble containing information on individuals
evaluated for heart disease. It is a cleaned version of the original "Heart Disease" dataset
from the UCI Machine Learning Repository, and includes 303 observations on 9 variables.
}
\details{
The dataset name has been kept as 'heartdisease_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
CardioDataSets package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble. The original content has not been modified
in any way.
}
