% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_semipmetric_erf.R
\name{estimate_semipmetric_erf}
\alias{estimate_semipmetric_erf}
\title{Estimate semi-exposure-response function (semi-ERF).}
\usage{
estimate_semipmetric_erf(formula, family, data, ...)
}
\arguments{
\item{formula}{a vector of outcome variable in matched set.}

\item{family}{a description of the error distribution (see ?gam).}

\item{data}{dataset that formula is build upon.}

\item{...}{Additional parameters for further fine tuning the gam model.}
}
\value{
returns an object of class gam
}
\description{
Estimates the smoothed exposure-response function using a generalized
additive model with splines.
}
\details{
This approach uses Generalized Additive Model (gam) using mgcv package.
}
\examples{
m_d <- generate_syn_data(sample_size = 100)
pseudo_pop <- generate_pseudo_pop(m_d[, c("id", "Y")],
                                  m_d[, c("id", "w")],
                                  m_d[, c("id", "cf1","cf2","cf3","cf4","cf5","cf6")],
                                  ci_appr = "matching",
                                  sl_lib = c("m_xgboost"),
                                  params = list(xgb_nrounds=c(10,20,30),
                                   xgb_eta=c(0.1,0.2,0.3)),
                                  nthread = 1,
                                  covar_bl_method = "absolute",
                                  covar_bl_trs = 0.1,
                                  covar_bl_trs_type = "mean",
                                  max_attempt = 1,
                                  dist_measure = "l1",
                                  delta_n = 1,
                                  scale = 0.5)

outcome_m <- estimate_semipmetric_erf (formula = Y ~ w,
                                       family = gaussian,
                                       data = pseudo_pop$pseudo_pop)


}
