% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_model.R
\name{query_distribution}
\alias{query_distribution}
\title{Calculate query distribution}
\usage{
query_distribution(
  model,
  query,
  given = TRUE,
  using = "priors",
  parameters = NULL,
  type_distribution = NULL,
  verbose = FALSE,
  join_by = "|"
)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}

\item{query}{A character. A query on potential outcomes such as "Y[X=1] - Y[X=0]"}

\item{given}{A character. A quoted expression evaluates to logical statement. given allows estimand to be conditioned on *observational* distribution.}

\item{using}{A character. Whether to use `priors`, `posteriors` or `parameters`}

\item{parameters}{A vector of real numbers in [0,1].  A true parameter vector to be used instead of parameters attached to the model in case  `using` specifies `parameters`}

\item{type_distribution}{A numeric vector. If provided saves calculation, otherwise calculated from model; may be based on prior or posterior}

\item{verbose}{Logical. Whether to print mean and standard deviation of the estimand on the console.}

\item{join_by}{A character. The logical operator joining expanded types when \code{query} contains wildcard (\code{.}). Can take values \code{"&"} (logical AND) or \code{"|"} (logical OR). When restriction contains wildcard (\code{.}) and \code{join_by} is not specified, it defaults to \code{"|"}, otherwise it defaults to \code{NULL}.}
}
\value{
A vector of draws from the distribution of the potential outcomes specified in `query`
}
\description{
Calculated distribution of a query from a prior or posterior distribution of parameters
}
\examples{
model <- make_model("X -> Y") \%>\%
         set_prior_distribution()
 \donttest{
 distribution <- query_distribution(model, query = "(Y[X=1] - Y[X=0])")

 distribution <- query_distribution(model, query = "(Y[X=1] - Y[X=0])", given = "X==1")
 distribution <- query_distribution(model, query = "(Y[X=1] - Y[X=0])", given = "Y[X=1]==1")
 distribution <- query_distribution(model, query = "(Y[X=1] > Y[X=0])")
 distribution <- query_distribution(model, query = "(Y[X=.] == 1)", join_by = "&")
 distribution <- query_distribution(model, query = "(Y[X=1] - Y[X=0])", using = "parameters")
 df    <- simulate_data(model, n = 3)
 updated_model <- update_model(model, df)
 query_distribution( updated_model , query = "(Y[X=1] - Y[X=0])", using = "posteriors")
}
}
