% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpectraDist.R
\name{plotSpectraDist}
\alias{plotSpectraDist}
\title{Plot the Distance Between Spectra and a Reference Spectrum in a Spectra Object}
\usage{
plotSpectraDist(spectra, method = "pearson", ref = 1, labels = TRUE, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}}.}

\item{method}{Character.  Any method acceptable to \code{\link{rowDist}}.}

\item{ref}{Integer.  The spectrum to be used as a reference.}

\item{labels}{Logical.  Shall the points be labeled?}

\item{\dots}{Parameters to be passed to the plotting routines. \emph{Applies to base graphics only}.}
}
\value{
The returned value depends on the graphics option selected (see \code{\link{GraphicsOptions}}).
\describe{
 \item{base:}{A data frame or list containing the data plotted.  Assign the value and run \code{str()}
              or \code{names()} on it to see what it contains. Side effect is a plot.}
 \item{ggplot2:}{The plot is displayed, and a \code{ggplot2} plot object is returned if the
                 value is assigned. The plot can be modified in the usual \code{ggplot2} manner.
                 If you want the plotted values, you can access them via the base graphics mode.}
}
}
\description{
This function plots the distance between a reference spectrum and all other
spectra in a \code{\link{Spectra}} object.  Distance can be defined in a number of
ways (see Arguments).
}
\examples{

# This example assumes the graphics output is set to ggplot2 (see ?GraphicsOptions).
library("ggplot2")
data(SrE.NMR)
txt1 <- paste("Distance from", SrE.NMR$names[1])
txt2 <- paste("Rank Distance from", SrE.NMR$names[1])
p <- plotSpectraDist(SrE.NMR)
p <- p + labs(title = txt1, xlab = txt2, ylab = txt2) +
         coord_cartesian(ylim = c(0, 1.1), xlim = c(0, 16))
p

}
\seealso{
To compare all spectra simultaneously in a heatmap, see
\code{\link[ChemoSpecUtils]{sampleDist}}.  Additional documentation
at \url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University), Tejasvi Gupta.
}
\keyword{hplot}
\keyword{multivariate}
