/*
 * Decompiled with CFR 0.152.
 */
package core.explorer;

import core.explorer.ChordalysisModeller;
import core.model.ScoredGraphAction;
import core.stats.EntropyComputer;
import core.stats.scorer.GraphActionScorer;
import core.stats.scorer.GraphActionScorerPValue;

public class ChordalysisModellingBudget
extends ChordalysisModeller {
    double pValueThreshold;
    double budgetShare = 0.01;

    public ChordalysisModellingBudget(ChordalysisModeller.Data data, double pValueThreshold, double budgetShare) {
        super(data);
        this.pValueThreshold = pValueThreshold;
        this.budgetShare = budgetShare;
        if (budgetShare <= 0.0 || budgetShare > 1.0) {
            throw new RuntimeException("budgetShare has to be within ]0,1]");
        }
    }

    @Override
    protected GraphActionScorer initScorer() {
        EntropyComputer entropyComputer = new EntropyComputer(this.lattice);
        return new GraphActionScorerPValue(entropyComputer);
    }

    @Override
    public void explore() {
        this.pq.processStoredModifications();
        double remainingBudget = this.pValueThreshold;
        int step = 0;
        while (!this.pq.isEmpty() && step < this.maxNSteps) {
            int nbTests = this.pq.size();
            double budgetToUse = this.budgetShare * remainingBudget;
            double correctedPValueThreshold = budgetToUse / (double)nbTests;
            remainingBudget -= budgetToUse;
            ScoredGraphAction todo = (ScoredGraphAction)this.pq.poll();
            if (todo.getScore() > correctedPValueThreshold) break;
            this.operationsPerformed.add(todo);
            this.bestModel.performAction(todo, this.bestModel, this.pq);
            ++step;
        }
    }
}

