% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.doc.R
\name{report.doc}
\alias{report.doc}
\alias{report.doc.desc}
\title{Transform a desc object to a flexTable object ready to export to Word using officer}
\usage{
report.doc(table, ...)

\method{report.doc}{desc}(table, title, colspan.value = "", doc = NULL,
  init.numbering = F, numbering = T, font.name = "Times", ...)
}
\arguments{
\item{table}{a desc object that report statistics (the results of \code{report.quanti} or \code{report.quali})}

\item{...}{Other arguments}

\item{title}{Character. The title of the table}

\item{colspan.value}{Character. Add the label of the x1 variable levels (typically "Treatment Groups")}

\item{doc}{NULL or a rdocx object}

\item{init.numbering}{Boolean. If TRUE Start numbering of the output at 1, otherwise it increase the output numbering of 1 unit}

\item{numbering}{Boolean. If TRUE Output numbers are added before the title.}

\item{font.name}{Character. Passed to font function. Set the font of the output in Word}
}
\description{
\code{report.doc} 
Export the table to MS word in "clinical standard" format.
}
\details{
It creates a flextable object from a desc object and can eventually add it directly into a rdocx object.
 @return  
A flextable object or a rdocx object.
}
\examples{
\dontshow{


library(officer)
library(flextable)
library(reshape2)
library(emmeans)
library(lme4)
library(nlme)

data(data)

tab=report.quanti(data=data,y="y_numeric",
	x1="GROUP",x2="TIMEPOINT",at.row="TIMEPOINT",subjid="SUBJID")

mod=glm(y_logistic~GROUP+TIMEPOINT+GROUP*TIMEPOINT,
family=binomial,data=data,na.action=na.omit)
test=emmeans(mod,~GROUP|TIMEPOINT)
tab.mod=report.lsmeans(lsm=test,x1.name="GROUP",
x2.name="TIMEPOINT",at.row="TIMEPOINT")


doc=read_docx()

doc=body_add_par(doc,"A beautiful reporting using ClinReport", style = "heading 1")

doc=report.doc(tab,title="Quantitative statistics",
	colspan.value="Treatment group",doc=doc,init.numbering=TRUE)


doc=report.doc(tab.mod,title="Generalized Linear Mixed Model LS-Means results using lme",
	colspan.value="Treatment group",doc=doc)

}


\donttest{
library(officer)
library(flextable)
library(reshape2)
library(emmeans)
library(lme4)
library(nlme)

data(data)

tab1=report.quanti(data=data,y="y_numeric",
	x1="GROUP",x2="TIMEPOINT",at.row="TIMEPOINT",subjid="SUBJID")

tab2=report.quali(data=data,y="y_logistic",
	x1="GROUP",x2="TIMEPOINT",at.row="TIMEPOINT",total=T,subjid="SUBJID")


tab3=report.quali(data=data,y="VAR",y.label="Whatever")

tab4=report.quali(data=data,y="VAR",y.label="Whatever",
	subjid="SUBJID")


tab5=report.quali(data=data,y="VAR",y.label="Whatever",x1="GROUP",
	subjid="SUBJID")


mod1=lm(y_numeric~GROUP+TIMEPOINT+GROUP*TIMEPOINT,data=data)
test1=emmeans(mod1,~GROUP|TIMEPOINT)
tab.mod1=report.lsmeans(lsm=test1,x1.name="GROUP",
x2.name="TIMEPOINT",at.row="TIMEPOINT")


mod2=lm(y_numeric~GROUP,data=data)
test2=emmeans(mod2,~GROUP)
tab.mod2=report.lsmeans(lsm=test2,x1.name="GROUP")


mod3=lme(y_numeric~GROUP+TIMEPOINT+GROUP*TIMEPOINT,
random=~1|SUBJID,data=data,na.action=na.omit)
test3=emmeans(mod3,~GROUP|TIMEPOINT)
tab.mod3=report.lsmeans(lsm=test3,x1.name="GROUP",
x2.name="TIMEPOINT",at.row="TIMEPOINT")


mod4=glm(y_logistic~GROUP+TIMEPOINT+GROUP*TIMEPOINT,
family=binomial,data=data,na.action=na.omit)
test4=emmeans(mod4,~GROUP|TIMEPOINT)
tab.mod4=report.lsmeans(lsm=test4,x1.name="GROUP",
x2.name="TIMEPOINT",at.row="TIMEPOINT")


mod5=glm(y_logistic~GROUP+TIMEPOINT+GROUP*TIMEPOINT,
family=binomial,data=data,na.action=na.omit)
test5=emmeans(mod5,~GROUP|TIMEPOINT)
tab.mod5=report.lsmeans(lsm=test5,x1.name="GROUP",
x2.name="TIMEPOINT",at.row="TIMEPOINT",type="response")


mod6=glm(y_poisson~GROUP+TIMEPOINT+GROUP*TIMEPOINT,
family=poisson,data=data,na.action=na.omit)
test6=emmeans(mod6,~GROUP|TIMEPOINT)

tab.mod6=report.lsmeans(lsm=test6,x1.name="GROUP",
x2.name="TIMEPOINT",at.row="TIMEPOINT",type="response")

mod7=lm(y_numeric~+GROUP+TIMEPOINT+VAR,
data=data,na.action=na.omit)
test7=emmeans(mod7,~GROUP:VAR|TIMEPOINT)
tab.mod7=report.lsmeans(lsm=test7,x1.name="GROUP",
x2.name="TIMEPOINT",x3.name="VAR",at.row="TIMEPOINT")



doc=read_docx()

doc=body_add_par(doc,"A beautiful reporting using ClinReport", style = "heading 1")

doc=report.doc(tab1,title="Quantitative statistics (2 explicative variables)",
	colspan.value="Treatment group",doc=doc,init.numbering=T)


doc=report.doc(tab2,title="Qualitative statistics (2 explicative variables)",
	colspan.value="Treatment group",doc=doc)


doc=report.doc(tab3,title="Qualitative statistics (1 variable only)",doc=doc)


doc=report.doc(tab.mod1,title="Linear Model LS-Means results using lm with interactions",
	colspan.value="Treatment group",doc=doc)

doc=report.doc(tab.mod2,title="Linear Model LS-Means results using lm without interaction",
	colspan.value="Treatment group",doc=doc)

doc=report.doc(tab.mod3,title="Linear Mixed Model LS-Means results using lme",
	colspan.value="Treatment group",doc=doc)

doc=report.doc(tab.mod4,title="Generalized Linear Mixed Model LS-Means results using lme",
	colspan.value="Treatment group",doc=doc)


doc=report.doc(tab.mod6,title="Poisson Model LS-Means results",
	colspan.value="Treatment group",doc=doc)


file=paste(tempfile(),".docx",sep="")
print(doc, target =file)
shell.exec(file)

}

}
\seealso{
\code{\link{report.quali}} \code{\link{report.quanti}} \code{\link{report.lsmeans}}
}
