% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.kmeans.torus.R
\name{pred.kmeans.torus}
\alias{pred.kmeans.torus}
\title{Prediction for Extrinsic Kmeans Clustering}
\usage{
pred.kmeans.torus(data, kmeans)
}
\arguments{
\item{data}{n x d matrix of toroidal data on \eqn{[0, 2\pi)^d}.}

\item{kmeans}{a \code{kmeans} object, which contains
input data, cluster centers on torus, membership,
total sum of squares, within cluster sum of squares,
between cluster centers sum of squares, and the size of
each cluster. See  \code{\link[ClusTorus]{kmeans.torus}}}
}
\value{
a vector whose elements indicate the labels of predicted clusters.
}
\description{
\code{pred.kmeans.torus} predicts the cluster for each
  data point.
}
\examples{
data <- ILE[1:200, 1:2]

split.id <- sample(1:2, nrow(data), replace = TRUE)
data.train <- data[split.id == 1, ]
data.test <- data[split.id == 2, ]

kmeans <- kmeans.torus(data.train, centers = 2,
             iter.max = 100, nstart = 1)

pred.kmeans.torus(data.test, kmeans)
}
\references{
'S. Jung, K. Park, and B. Kim (2021),
  "Clustering on the torus by conformal prediction"
}
\seealso{
\code{\link[ClusTorus]{kmeans.torus}}
}
