% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catatis.R
\name{catatis}
\alias{catatis}
\title{Perform the CATATIS method on different blocks from a CATA experiment}
\usage{
catatis(Data,nblo,NameBlocks=NULL, NameVar=NULL, Graph=TRUE, Graph_weights=TRUE,
 Test_weights=FALSE, nperm=100)
}
\arguments{
\item{Data}{data frame or matrix where the blocks of binary variables are merged horizontally. If you have a different format, see \code{\link{change_cata_format}}}

\item{nblo}{integer. Number of blocks (subjects).}

\item{NameBlocks}{string vector. Name of each block (subject). Length must be equal to the number of blocks. If NULL, the names are S1,...Sm. Default: NULL}

\item{NameVar}{string vector. Name of each variable (attribute, the same names for each subject). Length must be equal to the number of attributes. If NULL, the colnames of the first block are taken. Default: NULL}

\item{Graph}{logical. Show the graphical representation? Default: TRUE}

\item{Graph_weights}{logical. Should the barplot of the weights be plotted? Default: TRUE}

\item{Test_weights}{logical. Should the the weights be tested? Default: FALSE}

\item{nperm}{integer. Number of permutation for the weight tests. Default: 100}
}
\value{
a list with:
        \itemize{
         \item S: the S matrix: a matrix with the similarity coefficient among the subjects
         \item compromise: a matrix which is the compromise of the subjects (akin to a weighted average)
         \item weights: the weights associated with the subjects to build the compromise
         \item weights_tests: the weights tests results
         \item lambda:  the first eigenvalue of the S matrix
         \item overall error: the error for the CATATIS criterion
         \item error_by_sub: the error by subject (CATATIS criterion)
         \item error_by_prod: the error by product (CATATIS criterion)
         \item s_with_compromise: the similarity coefficient of each subject with the compromise
         \item homogeneity: homogeneity of the subjects (in percentage)
         \item CA: the results of correspondence analysis performed on the compromise dataset
         \item eigenvalues: the eigenvalues associated to the correspondence analysis
         \item inertia: the percentage of total variance explained by each axis of the CA
         \item scalefactors: the scaling factors of each subject
         \item nb_1: the number of 1 in each block, i.e. the number of checked attributes by subject.
         \item param: parameters called
         }
}
\description{
CATATIS method. Additional outputs are also computed. Non-binary data are accepted and weights can be tested.
}
\examples{
data(straw)
res.cat=catatis(straw, nblo=114)
summary(res.cat)
plot(res.cat)

#Vertical format with sessions
data("fish")
chang=change_cata_format2(fish, nprod= 6, nattr= 27, nsub = 12, nsess= 3)
res.cat2=catatis(Data= chang$Datafinal, nblo = 12, NameBlocks =  chang$NameSub, Test_weights=TRUE)

#Vertical format without sessions
Data=fish[1:66,2:30]
chang2=change_cata_format2(Data, nprod= 6, nattr= 27, nsub = 11, nsess= 1)
res.cat3=catatis(Data= chang2$Datafinal, nblo = 11, NameBlocks =  chang2$NameSub)


}
\references{
Llobell, F., Cariou, V., Vigneau, E., Labenne, A., & Qannari, E. M. (2019). A new approach for the analysis of data and the clustering of subjects in a CATA experiment. Food Quality and Preference, 72, 31-39.\cr
Bonnet, L., Ferney, T., Riedel, T., Qannari, E.M., Llobell, F. (September 14, 2022) .Using CATA for sensory profiling: assessment of the panel performance. Eurosense, Turku, Finland.
}
\seealso{
\code{\link{plot.catatis}}, \code{\link{summary.catatis}}, \code{\link{cluscata}}, \code{\link{change_cata_format}}, \code{\link{change_cata_format2}}
}
\keyword{CATA}
