% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclustgeo.R
\name{estuary}
\alias{estuary}
\title{estuary data}
\format{The R dataset estuary is a list of three objects: 
\itemize{
\item{dat: a data frame with the description of the n=303 municipalities on p=4 socio-demographic variables.}
 \item{D.geo: a matrix with the geographical distances between the town hall of the n=303 municipalities.}
 \item{map: an object of class \code{SpatialPolygonsDataFrame} with the map of the gironde estuary.}
 }}
\source{
Original data are issued from the French population census of National Institute 
of Statistics and Economic Studies for year 2009. The agricultural surface has been 
calculated on data coming from the French National Institute of Geographical and Forestry 
Information. The calculation of the ratio and recoding of categories have been made by 
Irstea Bordeaux.
}
\description{
Data refering to n=303 french municipalities  of gironde estuary (a south-ouest french county).
The data are issued from the French population census conducted by the National Institute 
of Statistics and Economic Studies. The dataset is an extraction of four quantitative 
socio-economic variables for a subsample of 303 french municipalities located on the
atlantic coast between Royan and Mimizan. \code{employ.rate.city} is the employment rate 
of the municipality, that is the ratio of the number of individuals who have a job to 
the population of working age (generally defined, for the purposes of international 
comparison, as persons of between 15 and 64 years of age). \code{graduate.rate} refers 
to the level of education of the population that is the highest degree declared by the 
individual. It is defined here as the ratio for the whole population having completed 
a diploma equivalent or of upper level to two years of higher education 
(DUT, BTS, DEUG, nursing and social training courses, license, maitrise, master, DEA, DESS, doctorate, or Grande Ecole diploma). 
\code{housing.appart} is the ratio of apartment housing. \code{agri.land} is the part of 
agricultural area of the municipality.
}
\examples{
data(estuary)
names(estuary)
head(estuary$dat)
sp::plot(estuary$map)
}
\references{
M.chavent, V. Kuentz-Simonet, A. Labenne, J. Saracco.  ClustGeo:  an R package 
for hierarchical clustering with spatial constraints	arXiv:1707.03897 [stat.CO]
}
\keyword{data}

