% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreparingTheData.R
\name{PreparingTheData}
\alias{PreparingTheData}
\title{Preparing dataset}
\usage{
PreparingTheData(DaTa, Pred)
}
\arguments{
\item{DaTa}{data.frame. The first column contains the time point information (natural numbers 1,2,3...). The rest of the columns contain the relative abundance of each bacteria at the different time points. The values of each column must sum 1.}

\item{Pred}{Number. The data at t=1,...,Pred-1 will be used to estimate the model. The rest of the time points will be used to study the capacity of the model to predict. If \code{Pred==0} all the datatset will be used to estimate the model.}
}
\value{
If \code{Pred==0} returns a list with
\itemize{
  \item \code{Tt} - The number of time points available.
  \item \code{E} - Number of bacteria available
   \item \code{especieOriginal} - Matrix that contains at row i the bacterial taxa of bacteria i at all time points.
  \item \code{especiemodiOriginal} - Matrix that contains at row i the bacterial taxa of bacteria i at time points t=2,...,\code{Tt}.
}

If \code{Pred!=0} returns a list with
\itemize{
  \item \code{Tt} - The number of time points available used to estimate the model (\code{Tt}=Pred-1).
  \item \code{E} - Number of bacteria available
   \item \code{especieOriginal} - Matrix that contains at row i the bacterial taxa of bacteria i at the time points t=1,2,...,Pred-1.
  \item \code{especiemodiOriginal} - Matrix that contains at row i the bacterial taxa of bacteria i at time points t=2,...,Pred-1.
  \item \code{especieOriginal.All} - Matrix that contains at row i the bacterial taxa of bacteria i at the time points.
  \item \code{especiemodiOriginal.All} - Matrix that contains at row i the bacterial taxa of bacteria i at time points.
 \item \code{K} - Number of time points available at the dataset.
}
}
\description{
Preparing the dataset to be introduce in the models' functions. In order to introduce the usage of the package there is a README file. You can find the link to the file using \code{base::system.file("extdata", "README.pdf", package = "CoDaLoMic")}. On windows you can open the file with \code{base::shell.exec(system.file("extdata", "README.pdf", package = "CoDaLoMic"))}.
}
\examples{


df<-data.frame(cbind(c(1,2,3),
                     c(0.5,0.2,0.3),
                     c(0.2,0.1,0.6),
                     c(0.1,0.1,0.8),
                     c(0.3,0.3,0.4)))
PreparingTheData(df,Pred=0)

df2<-data.frame(cbind(c(1,2,3,4,5),
                      c(0.1,0.1,0.1,0.2,0.5),
                      c(0.2,0.2,0.2,0.2,0.2),
                      c(0.2,0.3,0.1,0.2,0.2)))
PreparingTheData(df2,Pred=4)
}
