% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaPlotCtsemMod.R
\name{ctmaPlotCtsemMod}
\alias{ctmaPlotCtsemMod}
\title{ctmaPlotCtsemMod}
\usage{
ctmaPlotCtsemMod(
  ctStanFitObject = NULL,
  fitSummary = NULL,
  activeDirectory = NULL,
  Tipred.pos = 1,
  saveFilePrefix = "Moderator Plot ",
  scaleTime = 1,
  mod.sd.to.plot = -1:1,
  timeUnit = "not specified",
  timeRange = NULL,
  mod.type = "cont",
  no.mod.cats = NULL,
  n.x.labels = NULL,
  plot.xMin = 0,
  plot.xMax = NULL,
  plot.yMin = -1,
  plot.yMax = 1,
  plot..type = "l",
  plot.lty = 1,
  plot.col = "grey",
  plot.lwd = 1.5,
  dot.plot.type = "b",
  dot.plot.col = "black",
  dot.plot.lwd = 0.5,
  dot.plot.lty = 3,
  dot.plot.pch = 16,
  dot.plot.cex = 3
)
}
\arguments{
\item{ctStanFitObject}{The fit object with moderator (TIpred) effects to be plotted}

\item{fitSummary}{Mainl ofr debugging purpose. Saves computation time if provided in addition to the fit object}

\item{activeDirectory}{defines the active directory (where to save plots)}

\item{Tipred.pos}{the Tipred that represent the moderator. Could be more than one in case of categorical moderators (e.g., Tipred.pos = c(3,4))}

\item{saveFilePrefix}{Prefix used for saved plots}

\item{scaleTime}{factor to increase or decrease the time scale (e.g., 1/12 if estimates where based on yearly intervals and figure should show monthly intervals)}

\item{mod.sd.to.plot}{The standard deviation vlaues (default -1, 0, +1) for which the drift effects are plotted}

\item{timeUnit}{Label for the x-axis}

\item{timeRange}{time range across which drift effects are plotted}

\item{mod.type}{Could be either "cont" or "cat"}

\item{no.mod.cats}{Need to be specified if type = "cat". The number of categories should usually be equal the number of dummy variables used to represent the categorical moderator + 1.}

\item{n.x.labels}{How many values to be used for indicating time points on the x-axis (0 is automatically added and should not be counted)}

\item{plot.xMin}{default = 0}

\item{plot.xMax}{default = NULL}

\item{plot.yMin}{default = -1}

\item{plot.yMax}{default = 1}

\item{plot..type}{default = "l", # 2 dots .. are correct}

\item{plot.lty}{default = 1}

\item{plot.col}{default = "grey"}

\item{plot.lwd}{default =  1.5}

\item{dot.plot.type}{default =  "b" for the dots indicating the moderator values}

\item{dot.plot.col}{default ="black" for the dots indicating the moderator values}

\item{dot.plot.lwd}{default =  .5 for the dots indicating the moderator values}

\item{dot.plot.lty}{default = 3 for the dots indicating the moderator values}

\item{dot.plot.pch}{default = 16 for the dots indicating the moderator values}

\item{dot.plot.cex}{default = 3 for the dots indicating the moderator values}
}
\value{
writes png figures to disc using the path specified in the activeDirectory arguments.
}
\description{
Plots moderator models using \code{\link{ctsem}} fit objects
}
\examples{
#Plot a categorical moderator
\dontrun{
ctmaPlotCtsemMod(ctStanFitObject = ctsemFit,
                 activeDirectory=NULL,
                 mod.sd.to.plot = NULL,
                 timeUnit = "Months",
                 timeRange = c(0, 12, .1),
                 mod.type = "cat",
                 no.mod.cats = NULL
}

}
