% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugCodes.R
\name{getDrugIngredientCodes}
\alias{getDrugIngredientCodes}
\title{Get descendant codes for drug ingredients}
\usage{
getDrugIngredientCodes(
  cdm,
  name = NULL,
  doseForm = NULL,
  ingredientRange = c(1, Inf),
  withConceptDetails = FALSE
)
}
\arguments{
\item{cdm}{cdm_reference via CDMConnector}

\item{name}{Names of ingredients of interest. For example, c("acetaminophen",
"codeine"), would result in a list of length two with the descendant
concepts for these two particular drug ingredients.}

\item{doseForm}{Only descendants codes with the specified dose form
will be returned. If NULL, descendant codes will be returned regardless
of dose form.}

\item{ingredientRange}{Used to restrict descendant codes to those
associated with a specific number of ingredients. Must be a vector of length
two with the first element the minimum number of ingredients allowed and
the second the maximum. A value of c(2, 2) would restrict to only concepts
associated with two ingredients.}

\item{withConceptDetails}{If FALSE, each item in the list of results (one per
ingredient) will contain a vector of concept IDs for each ingredient. If
TRUE each item in the list of results will contain a tibble with additional
information on the identified concepts.}
}
\value{
A named list, with each item containing a vector of descendant
concepts of an ingredient (if withConceptDetails was set as FALSE) or a
tibble with the descendant concepts along with additional details about them
(if withConceptDetails was set as TRUE).
}
\description{
Get descendant codes for drug ingredients
}
\examples{
\dontrun{
cdm <- mockVocabRef()
getDrugIngredientCodes(cdm = cdm, name = "Adalimumab")
CDMConnector::cdmDisconnect(cdm)
}
}
