% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireDemographics.R
\name{requireSex}
\alias{requireSex}
\title{Restrict cohort on sex}
\usage{
requireSex(cohort, sex, cohortId = NULL, name = tableName(cohort))
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{sex}{Can be "Both", "Male" or "Female". If one of the latter, only
those with that sex will be included.}

\item{cohortId}{IDs of the cohorts to modify. If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{name}{Name of the new cohort with the sex requirements.}
}
\value{
The cohort table with only records for individuals satisfying the
sex requirement
}
\description{
Restrict cohort on sex
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()
cdm$cohort1 |>
  requireSex(sex = "Female")
}
}
