% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearCohorts.R
\name{yearCohorts}
\alias{yearCohorts}
\title{Generate a new cohort table restricting cohort entries to certain years}
\usage{
yearCohorts(cohort, years, cohortId = NULL, name = tableName(cohort))
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{years}{Numeric vector of years to use to restrict observation to..}

\item{cohortId}{Vector identifying which cohorts to include
(cohort_definition_id or cohort_name). Cohorts not included will be
removed from the cohort set.}

\item{name}{Name of the new cohort table created in the cdm object.}
}
\value{
A cohort table.
}
\description{
\code{yearCohorts()} splits a cohort into multiple cohorts, one for each year.
}
\examples{
\donttest{
library(CohortConstructor)

cdm <- mockCohortConstructor(nPerson = 100)

cdm$cohort1 <- cdm$cohort1 |> yearCohorts(years = 2000:2002)
settings(cdm$cohort1)
}
}
