% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseSequenceRatios.R
\name{summariseSequenceRatios}
\alias{summariseSequenceRatios}
\title{Sequence ratio calculations}
\usage{
summariseSequenceRatios(
  cohort,
  cohortId = NULL,
  confidenceInterval = 95,
  minCellCount = 5
)
}
\arguments{
\item{cohort}{A cohort table in the cdm.}

\item{cohortId}{The Ids in the cohort that are to be included in the analyses.}

\item{confidenceInterval}{Default is 95, indicating the central 95\% confidence interval.}

\item{minCellCount}{The minimum number of events to reported, below which
results will be obscured. If 0, all results will be reported.}
}
\value{
A local table with all the analyses.
}
\description{
Using generateSequenceCohortSet to obtain sequence ratios for the desired outcomes.
}
\examples{
\donttest{
library(CohortSymmetry)
cdm <- mockCohortSymmetry()
cdm <- generateSequenceCohortSet(cdm = cdm,
                                 name = "joined_cohorts",
                                 indexTable = "cohort_1",
                                 markerTable = "cohort_2")
pssa_result <- summariseSequenceRatios(cohort = cdm$joined_cohorts, minCellCount = 0)
pssa_result
CDMConnector::cdmDisconnect(cdm)
}

}
