# Download geospatial works as expected

    Code
      download_geospatial(spatial_level = "department", simplified = TRUE,
        include_geom = TRUE, include_cnpv = FALSE)
    Message
      Original data is retrieved from the National Administrative Department
      of Statistics (Departamento Administrativo Nacional de Estadística -
      DANE).
      Reformatted by package authors.
      Stored by Universidad de Los Andes under the Epiverse TRACE iniative.
    Output
      Simple feature collection with 33 features and 6 fields
      Geometry type: MULTIPOLYGON
      Dimension:     XY
      Bounding box:  xmin: -81.73562 ymin: -4.229407 xmax: -66.84722 ymax: 13.3945
      Geodetic CRS:  WGS 84
      First 10 features:
         codigo_departamento    departamento version         area    latitud
      1                   18         Caquetá    2018  90103008160  0.7985562
      2                   19           Cauca    2018  31242914793  2.3968339
      3                   86        Putumayo    2018  25976283135  0.4522600
      4                   76 Valle del Cauca    2018  20665544525  3.8588583
      5                   94         Guainía    2018  71289354481  2.7278429
      6                   99         Vichada    2018 100063370591  4.7135571
      7                   85        Casanare    2018  44394239774  5.4040642
      8                   91        Amazonas    2018 109497053795 -1.5462277
      9                   97          Vaupés    2018  53299280015  0.6462456
      10                  95        Guaviare    2018  55575233166  1.9245320
          longitud                           geom
      1  -73.95947 MULTIPOLYGON (((-73.66003 1...
      2  -76.82423 MULTIPOLYGON (((-76.05542 3...
      3  -75.85591 MULTIPOLYGON (((-76.08495 1...
      4  -76.51869 MULTIPOLYGON (((-77.2381 4....
      5  -68.81661 MULTIPOLYGON (((-69.84572 1...
      6  -69.41400 MULTIPOLYGON (((-67.7076 4....
      7  -71.60188 MULTIPOLYGON (((-69.83591 6...
      8  -71.50213 MULTIPOLYGON (((-69.43297 -...
      9  -70.56141 MULTIPOLYGON (((-70.1096 2....
      10 -72.12860 MULTIPOLYGON (((-71.07753 2...

# Download geospatial works as expected with different parameters

    Code
      download_geospatial(spatial_level = "dpto", simplified = TRUE, include_geom = FALSE,
        include_cnpv = TRUE)
    Message
      Original data is retrieved from the National Administrative Department
      of Statistics (Departamento Administrativo Nacional de Estadística -
      DANE).
      Reformatted by package authors.
      Stored by Universidad de Los Andes under the Epiverse TRACE iniative.
    Output
         codigo_departamento                                             departamento
      1                   18                                                  Caquetá
      2                   19                                                    Cauca
      3                   86                                                 Putumayo
      4                   76                                          Valle del Cauca
      5                   94                                                  Guainía
      6                   99                                                  Vichada
      7                   85                                                 Casanare
      8                   91                                                 Amazonas
      9                   97                                                   Vaupés
      10                  95                                                 Guaviare
      11                  17                                                   Caldas
      12                  63                                                  Quindio
      13                  66                                                Risaralda
      14                  05                                                Antioquia
      15                  27                                                    Chocó
      16                  52                                                   Nariño
      17                  23                                                  Córdoba
      18                  13                                                  Bolívar
      19                  20                                                    Cesar
      20                  44                                               La Guajira
      21                  47                                                Magdalena
      22                  70                                                    Sucre
      23                  88 Archipiélago de San Andrés, Providencia y Santa Catalina
      24                  81                                                   Arauca
      25                  15                                                   Boyacá
      26                  25                                             Cundinamarca
      27                  54                                       Norte de Santander
      28                  11                                             Bogotá, D.C.
      29                  50                                                     Meta
      30                  41                                                    Huila
      31                  68                                                Santander
      32                  73                                                   Tolima
      33                  08                                                Atlántico
         version encuestas enc_etnico enc_no_etnico enc_resguardo_indigena
      1     2018    163381       1117        162264                   1117
      2     2018    622959      83033        539926                  70827
      3     2018    147797       4704        143093                   4659
      4     2018   1674673      18250       1656423                   3618
      5     2018     13059       3675          9384                   3675
      6     2018     24915       6870         18045                   6870
      7     2018    200495       1324        199171                   1324
      8     2018     21728       5008         16720                   5008
      9     2018      8008       4332          3676                   4332
      10    2018     34687       1429         33258                   1429
      11    2018    485640      11689        473951                  11689
      12    2018    233281         39        233242                     39
      13    2018    402838       4148        398690                   3415
      14    2018   2831531       7857       2823674                   5091
      15    2018    181847      63285        118562                  12768
      16    2018    689353     101987        587366                  73232
      17    2018    601587       9611        591976                   9611
      18    2018    705254       7548        697706                      0
      19    2018    414890       7232        407658                   7232
      20    2018    277023      77044        199979                  77021
      21    2018    484336       3954        480382                   3954
      22    2018    354991       6527        348464                   6527
      23    2018     26963          0         26963                      0
      24    2018    112562       1220        111342                   1220
      25    2018    967834       1419        966415                   1419
      26    2018   1551468        441       1551027                    441
      27    2018    566486       1194        565292                   1194
      28    2018   2737495          0       2737495                      0
      29    2018    476510       3583        472927                   3583
      30    2018    495841       1761        494080                   1761
      31    2018    988751          0        988751                      0
      32    2018    648829       8527        640302                   8527
      33    2018    753414          0        753414                      0
         enc_comun_negras enc_area_protegida enc_area_no_protegida un_vivienda
      1                 0                544                162837      132937
      2             12206                226                622733      446806
      3                45               1389                146408      107456
      4             14632              21431               1653242     1410067
      5                 0                532                 12527       11111
      6                 0                171                 24744       20051
      7                 0                617                199878      141678
      8                 0                492                 21236       16380
      9                 0                161                  7847        7149
      10                0                878                 33809       27218
      11                0               2250                483390      365721
      12                0               2316                230965      194213
      13              733               6964                395874      335469
      14             2766              36197               2795334     2288816
      15            50517               2212                179635      151290
      16            28755               9125                680228      467990
      17                0              65457                536130      452924
      18             7548                263                704991      582477
      19                0                331                414559      337076
      20               23               6402                270621      234492
      21                0              21455                462881      380600
      22                0               3583                351408      260138
      23                0                 11                 26952       18104
      24                0                230                112332       83727
      25                0              20066                947768      497803
      26                0              20647               1530821     1085084
      27                0               2069                564417      461100
      28                0              26695               2710800     2483914
      29                0               5878                470632      357843
      30                0               5270                490571      378843
      31                0              77476                911275      747923
      32                0                935                647894      496500
      33                0                163                753251      664640
         un_mixto un_no_res un_lea un_mixto_no_res_industria un_mixto_no_res_comercio
      1      5429     24804    211                        96                     3860
      2     10837    165011    324                       328                     6147
      3      3397     36789    173                        67                     2572
      4     39096    224820    690                      1920                    22705
      5       293      1553    102                        12                      154
      6       747      4016    101                        12                      548
      7      7105     51508    204                       248                     5038
      8       531      4788     29                        12                      286
      9       191       537    131                         0                      126
      10     1441      5925    103                        39                      977
      11     7240    112522    157                       225                     4035
      12     5094     33730    244                       135                     3187
      13     6726     60442    201                       321                     4295
      14    33470    507546   1794                      2803                    19341
      15     3488     27014     55                        93                     2274
      16    12911    208048    404                       331                     7919
      17    12577    135969    117                       275                     7958
      18    16461    106095    221                       228                     9773
      19    17454     60261     99                       362                     7961
      20     5042     37428     61                       104                     2834
      21    14441     89182    113                       302                     7090
      22     8041     86779     33                       198                     5012
      23      306      8540     13                         6                      118
      24     3933     24852     50                        87                     2864
      25    21954    447821    268                       507                    13066
      26    38933    426650    801                      1094                    20420
      27    18694     86525    167                       976                    11482
      28    39605    213068    908                      3905                    23685
      29    14581    103583    503                       382                    10407
      30    12592    104195    211                       335                     8060
      31    25660    214701    467                      1345                    15090
      32    18075    133864    390                       688                    11676
      33    17008     71527    261                       537                    11746
         un_mixto_no_res_servicios un_mixto_no_res_agro un_mixto_no_res_sin_info
      1                       1117                  243                      113
      2                       2276                 2016                       70
      3                        717                   29                       12
      4                      11986                 2357                      128
      5                        106                    6                       15
      6                        151                   22                       14
      7                       1677                  134                        8
      8                        185                   12                       36
      9                         50                    1                       14
      10                       367                   11                       47
      11                      1602                 1373                        5
      12                      1179                  590                        3
      13                      1730                  377                        3
      14                      7403                 3879                       44
      15                       748                  104                      269
      16                      2539                 1904                      218
      17                      3063                 1275                        6
      18                      3354                 3101                        5
      19                      4181                 4904                       46
      20                      1442                  652                       10
      21                      3286                 3744                       19
      22                      2342                  482                        7
      23                       182                    0                        0
      24                       699                  282                        1
      25                      2963                 5406                       12
      26                      4675                12683                       61
      27                      3867                 2337                       32
      28                     10268                 1679                       68
      29                      2357                 1393                       42
      30                      2915                 1276                        6
      31                      4955                 4205                       65
      32                      3592                 2101                       18
      33                      4175                  533                       17
         un_no_res_industria un_no_res_comercio un_no_res_servicios un_no_res_agro
      1                  160               5422                2511           3052
      2                  810              10334                9455          43342
      3                  188               4402                2485           6665
      4                 5572              50097               40191          32665
      5                   15                244                 263             24
      6                   13                601                 418             25
      7                  568               7907                4626           4681
      8                   25                564                 705              4
      9                    2                 74                 110              1
      10                  73               1463                 967             39
      11                1420              17132               14499          34894
      12                 576              10399                5607           6302
      13                1278              16647                9490          14132
      14               10395             111425               69260          80359
      15                 362               5432                4699            195
      16                 979              15353                9559         102518
      17                 530              16941               11069          26041
      18                 694              16913               10942          19461
      19                 483              10300                9000           9089
      20                 159               5786                4799           2044
      21                 655              14992                9867          21153
      22                 367               8476                7989          19497
      23                  30                985                1276              4
      24                 194               5058                2701           1964
      25                2015              22115               13092         161756
      26                4674              40530               15210         132742
      27                1529              17211               10345          17227
      28               20139              98313               59842           3895
      29                1080              18308                7494          11889
      30                 723              14650               10059          29656
      31                3575              37180               21190          46907
      32                 938              17672                8706          33886
      33                2088              19238               12574           3183
         un_no_res_institucional un_no_res_lote un_no_res_parque un_no_res_minero
      1                     1250          10099              678               12
      2                     3515          86486             3155              105
      3                     1428          18445              368               74
      4                     5452          67080             6881              169
      5                      149            597               35                7
      6                      220           2290              109                3
      7                     1567          28448              865               52
      8                      198           2764              243                9
      9                       86            149               34                0
      10                     400           2128              154                2
      11                    3090          33800             2108              383
      12                     817           8030              604               11
      13                    1832          12562              994               76
      14                   11511         189084             7392             1210
      15                    1287           9737              197               15
      16                    3412          63756             4561               48
      17                    3612          68585             2305              124
      18                    3930          37378             5065              253
      19                    1956          21389             1009              201
      20                    1733          16958              545               34
      21                    2665          30055              985               85
      22                    2386          41328              952               94
      23                     157           5467               37                1
      24                     899          10726              705                5
      25                    4735         228796             2182              713
      26                    6765         206323             4753              630
      27                    3553          27182             2572              320
      28                    6459          13925             4518              141
      29                    2942          52713             2020              134
      30                    3185          36223             2461              235
      31                    5809          85318             2327             1349
      32                    3621          62602             1583              141
      33                    2328          24361             1297               73
         un_no_res_proteccion u_no_res_construccion u_no_res_sin_info viviendas
      1                    96                  1453                71    138366
      2                   969                  6596               244    457643
      3                   319                  2334                81    110853
      4                  1340                 14970               403   1449163
      5                     5                   206                 8     11404
      6                     6                   325                 6     20798
      7                   227                  2522                45    148783
      8                     3                   251                22     16911
      9                     2                    78                 1      7340
      10                    4                   679                16     28659
      11                 1557                  3571                68    372961
      12                  119                  1222                43    199307
      13                  723                  2642                66    342195
      14                 3819                 22156               935   2322286
      15                   26                  4843               221    154778
      16                 1204                  6399               259    480901
      17                  487                  6063               212    465501
      18                 1329                  9919               211    598938
      19                  385                  6345               104    354530
      20                   72                  5222                76    239534
      21                  293                  8289               143    395041
      22                  947                  4622               121    268179
      23                   13                   560                10     18410
      24                   82                  2471                47     87660
      25                 5453                  6797               167    519757
      26                 5053                  9293               677   1124017
      27                  286                  6081               219    479794
      28                  567                  4815               454   2523519
      29                  858                  5957               188    372424
      30                 1502                  5347               154    391435
      31                 2095                  8513               438    773583
      32                  276                  4304               135    514575
      33                   95                  6075               215    681648
         viv_casa viv_apartamento viv_cuarto viv_trad_indigena viv_trad_etnica
      1    115307           18322       3591               493              35
      2    372096           33837      18177             30035            2187
      3     90540           11052       8098               684              49
      4    902928          490230      52855              1173             518
      5      8577             690        311              1697              34
      6     14875            1163        719              3823              88
      7    113503           25674       8459               448              72
      8     14278            1335        857               356              21
      9      6219             221        171               611              25
      10    24156            2919       1311               188              14
      11   258414          103943       9467               735              73
      12   149798           42560       6455               123              40
      13   251812           81463       6618              2015              69
      14  1218936         1037197      60041              3376             578
      15   132653           10229       2216              7596            1899
      16   366565           71792      29195             10871            1432
      17   390272           50114      14826              8986             244
      18   408774          164705      22844              1050             494
      19   269485           58106      20663              5157             362
      20   129090           20073      18010             69055            2263
      21   301626           71654      17838              2728             191
      22   223417           29831       9711              4750             112
      23    11045            5440       1786                 2              70
      24    74904            5939       5488               890              45
      25   393601          109164      14342              1506             143
      26   710791          363997      47703               155             131
      27   372013           85369      21249               633              54
      28   831210         1538294     151963               178             174
      29   285631           68886      14290              2270              83
      30   316786           60335      12708               842              66
      31   488603          255424      28117               119             115
      32   388450          105103      18829              1042              99
      33   383298          268000      28752               224             108
         viv_otro viv_ocupado_personas viv_ocupado_sin_personas viv_temporal
      1       618               110525                     4306         7299
      2      1311               367793                    24327        32268
      3       430                91508                     3418         5761
      4      1459              1231570                    64873        41444
      5        95                 9364                       72          660
      6       130                17699                      184          906
      7       627               120179                     3269        11384
      8        64                15422                      341          462
      9        93                 6829                       73          177
      10       71                22146                     1832         1393
      11      329               304509                    10647        20710
      12      331               170054                     6942         5733
      13      218               273259                    24051        11720
      14     2158              1933583                    70947       124578
      15      185               128125                     2221         7367
      16     1046               407276                    12995        25244
      17     1059               411879                     6684        10691
      18     1071               509169                    10654        25420
      19      757               296535                     9047        16522
      20     1043               214867                      611         9796
      21     1004               319306                     2615        33899
      22      358               229335                      788         8534
      23       67                16197                      133         1091
      24      394                70994                     3941         4927
      25     1001               369111                     7882        62027
      26     1240               899740                     8705       104525
      27      476               384715                    27574        15692
      28     1700              2345190                    33344        26233
      29     1264               288760                    19794        23748
      30      698               301651                    12791        39969
      31     1205               608376                    26898        46579
      32     1052               406884                    10697        52012
      33     1266               598179                    26361         9992
         viv_desocupado hogares viv_energia viv_sin_energia viv_energia_estrato_1
      1           16236  116166       93242           17283                 70029
      2           33255  432493      336910           30883                228576
      3           10166  107053       70944           20564                 58033
      4          111276 1267039     1216379           15191                321720
      5            1308    9953        5822            3542                  3421
      6            2009   19162        7697           10002                  5721
      7           13951  128130      112348            7831                 57192
      8             686   16290       11954            3468                  5040
      9             261    7020        3249            3580                  2083
      10           3288   22817       16455            5691                 10779
      11          37095  309680      300623            3886                 76889
      12          16578  174231      168496            1558                 46372
      13          33165  277932      271487            1772                 61304
      14         193178 1983566     1910386           23197                448806
      15          17065  133687       97143           30982                 88058
      16          35386  449275      370826           36450                256642
      17          36247  466615      395853           16026                323126
      18          53695  542694      482243           26926                319200
      19          32426  316717      279957           16578                182207
      20          14260  227367      130335           84532                 82287
      21          39221  343790      300043           19263                200595
      22          29522  240068      221591            7744                172374
      23            989   16354       16102              95                  4255
      24           7798   75261       65030            5964                 47674
      25          80737  381868      358502           10609                 94785
      26         111047  945586      885722           14018                157097
      27          51813  398300      368120           16595                144924
      28         118752 2514482     2339400            5790                196795
      29          40122  304244      266456           22304                 95939
      30          37024  319750      288382           13269                144716
      31          91730  647157      602751            5625                207725
      32          44982  423353      397981            8903                147039
      33          47116  625123      591697            6482                306315
         viv_energia_estrato_2 viv_energia_estrato_3 viv_energia_estrato_4
      1                  16659                  3868                   523
      2                  51555                 22577                 10705
      3                   9096                  1002                    46
      4                 438056                295053                 84368
      5                   1401                   144                     5
      6                   1351                   214                     5
      7                  39524                 12084                  1312
      8                   3174                  1651                    89
      9                    260                   113                     3
      10                  4236                   874                    19
      11                109157                 77857                 19187
      12                 62811                 37158                 10348
      13                 95613                 67441                 25983
      14                702517                498508                131061
      15                  4331                  1502                    43
      16                 67775                 27876                  8991
      17                 46355                 14129                  3792
      18                 98942                 40080                 11427
      19                 60806                 20677                  4569
      20                 27860                  6180                   467
      21                 41727                 38193                  7218
      22                 37257                  6770                  2205
      23                  7264                  3666                   392
      24                 12203                  2497                   238
      25                196356                 50587                 11192
      26                447484                230260                 34489
      27                156382                 45816                 16116
      28                917668                810356                263774
      29                 90791                 64325                  7908
      30                113382                 19587                  5773
      31                181238                121733                 68488
      32                174017                 56149                 14024
      33                152912                 75770                 32852
         viv_energia_estrato_5 viv_energia_estrato_6 viv_energia_sin_estrato
      1                     20                     7                    2136
      2                   2682                   564                   20251
      3                     15                    37                    2715
      4                  54589                 16599                    5994
      5                      3                     1                     847
      6                      1                     1                     404
      7                     67                    12                    2157
      8                      9                     3                    1988
      9                      1                     1                     788
      10                     7                     2                     538
      11                  5929                  9002                    2602
      12                  8936                  1307                    1564
      13                 11510                  7643                    1993
      14                 78960                 35376                   15158
      15                     8                    11                    3190
      16                  2700                    64                    6778
      17                  1203                   987                    6261
      18                  4712                  3554                    4328
      19                  2112                   536                    9050
      20                   157                    20                   13364
      21                  1972                  2886                    7452
      22                   484                   280                    2221
      23                   161                    45                     319
      24                    10                     6                    2402
      25                  4069                    68                    1445
      26                  5734                  4261                    6397
      27                  2706                   493                    1683
      28                 83473                 61257                    6077
      29                  3135                   997                    3361
      30                  1161                   116                    3647
      31                 11062                  8802                    3703
      32                  2554                   515                    3683
      33                 10611                  9397                    3840
         viv_acueducto viv_sin_acueducto viv_alcantarillado viv_sin_alcantarillado
      1          80362             30163              72630                  37895
      2         239233            128560             163290                 204503
      3          47315             44193              49898                  41610
      4        1174360             57210            1119657                 111913
      5           2047              7317               2621                   6743
      6           6506             11193               1140                  16559
      7          95984             24195              87851                  32328
      8           5962              9460               5241                  10181
      9           2393              4436               2124                   4705
      10         10029             12117              10255                  11891
      11        270261             34248             247395                  57114
      12        165221              4833             154836                  15218
      13        256692             16567             240402                  32857
      14       1741310            192273            1597608                 335975
      15         36562             91563              26082                 102043
      16        294873            112403             197862                 209414
      17        280367            131512             171842                 240037
      18        400728            108441             259262                 249907
      19        250721             45814             219074                  77461
      20        100043            114824              89975                 124892
      21        230955             88351             167990                 151316
      22        195362             33973             129300                 100035
      23          5940             10257               2687                  13510
      24         51727             19267              40868                  30126
      25        315674             53437             233357                 135754
      26        807017             92723             690966                 208774
      27        320229             64486             304985                  79730
      28       2332920             12270            2325515                  19675
      29        228211             60549             226219                  62541
      30        256798             44853             207477                  94174
      31        516267             92109             461115                 147261
      32        345378             61506             301140                 105744
      33        576711             21468             511207                  86972
         viv_gas viv_sin_gas viv_sin_info_gas viv_rec_basuras viv_sin_rec_basuras
      1    40608       67966             1951           80237               30288
      2   101100      264114             2579          163693              204100
      3    13261       77496              751           54930               36578
      4  1003741      218169             9660         1156676               74894
      5        0        9364                0            3615                5749
      6        0       17699                0            6424               11275
      7    90065       29004             1110           94829               25350
      8      298       14605              519            7759                7663
      9        0        6829                0            2438                4391
      10    4150       17644              352           13943                8203
      11  191171      111351             1987          249435               55074
      12  136914       31826             1314          159096               10958
      13  206994       64716             1549          244517               28742
      14 1194873      726032            12678         1720765              212818
      15    2970      120297             4858           62208               65917
      16   31580      371653             4043          221799              185477
      17  194127      215661             2091          217204              194675
      18  355014      151530             2625          362286              146883
      19  192045      102382             2108          228850               67685
      20   86305      127499             1063           99152              115715
      21  206326      111040             1940          223958               95348
      22  132145       95876             1314          133504               95831
      23       0       16197                0           15729                 468
      24    2872       67530              592           48238               22756
      25  191122      174513             3476          236721              132390
      26  624544      268719             6477          739380              160360
      27  189440      191882             3393          319405               65310
      28 2183785      131835            29570         2329993               15197
      29  191182       94374             3204          240108               48652
      30  200504       98726             2421          206020               95631
      31  414796      188820             4760          484014              124362
      32  281894      120883             4107          301922              104962
      33  535085       59552             3542          565186               32993
         viv_internet viv_sin_internet viv_sin_info_internet personas per_leas
      1         16740            91374                  2411   359602    11260
      2         57774           307230                  2789  1243503     7969
      3          9947            80704                   857   283197     5720
      4        683961           537450                 10159  3789874    27645
      5           693             8442                   229    44431     6849
      6           903            16357                   439    76642     5237
      7         30308            88743                  1128   379892     5264
      8           788            13972                   662    66056     3858
      9           280             6253                   296    37690     8727
      10         2809            18904                   433    73081     6054
      11       130032           172438                  2039   923472     8688
      12        77442            91272                  1340   509640     4029
      13       142422           129220                  1617   839597     4837
      14      1007573           913146                 12864  5974788    43296
      15        17058           104918                  6149   457412     3053
      16        69296           332893                  5087  1335521     8934
      17        72344           337380                  2155  1555596     3523
      18       134641           371856                  2672  1909460     6004
      19        76308           218026                  2201  1098577     4994
      20        23171           190543                  1153   825364     6984
      21        79508           237765                  2033  1263788     3246
      22        37837           190167                  1331   864036     3911
      23         4333            11788                    76    48299      465
      24         9395            61005                   594   239503     2757
      25        90750           274840                  3521  1135698    11208
      26       377456           515669                  6615  2792877    24080
      27       108485           272722                  3508  1346806     9063
      28      1748648           566617                 29925  7181469    31929
      29        97245           188198                  3317   919129    17909
      30        77438           221755                  2458  1009548     7694
      31       274017           329400                  4959  2008841    16812
      32       123546           279180                  4158  1228763    11263
      33       274001           320552                  3626  2342265     5831
         per_hogares_particulares hombres mujeres per_0_a_9 per_10_a_19 per_20_a_29
      1                    348342  182378  177224     63844       78433       62230
      2                   1235534  615833  627670    198781      224899      218267
      3                    277477  142900  140297     47232       60789       51033
      4                   3762229 1800614 1989260    460691      571709      632594
      5                     37582   23214   21217     11162       12028        7334
      6                     71405   40694   35948     19441       19099       12840
      7                    374628  192020  187872     64926       72670       67943
      8                     62198   34422   31634     14778       17085       10854
      9                     28963   19793   17897     10060       11678        5253
      10                    67027   39080   34001     12391       16919       12530
      11                   914784  447499  475973    105062      140617      144638
      12                   505611  245663  263977     56160       75254       81919
      13                   834760  401748  437849    101485      128381      136950
      14                  5931492 2885383 3089405    727218      949296     1067020
      15                   454359  225982  231430    104175       98185       77943
      16                  1326587  653754  681767    185456      239283      230622
      17                  1552073  774448  781148    265781      305539      249776
      18                  1903456  947598  961862    336353      354475      319569
      19                  1093583  543838  554739    214032      220335      188627
      20                   818380  404215  421149    196282      177972      143626
      21                  1260542  632502  631286    235042      254661      206913
      22                   860125  434459  429577    149080      163281      139879
      23                    47834   23326   24973      6799        7214        8025
      24                   236746  121060  118443     43484       47920       43899
      25                  1124490  559084  576614    156972      197722      170156
      26                  2768797 1379858 1413019    390278      465449      473354
      27                  1337743  664057  682749    209424      238188      236410
      28                  7149540 3433586 3747883    860140     1029517     1376341
      29                   901220  464906  454223    144652      169706      158842
      30                  1001854  503766  505782    163896      187209      169624
      31                  1992029  983439 1025402    282268      320397      337210
      32                  1217500  609017  619746    169025      208603      186565
      33                  2336434 1140357 1201908    366651      398326      403676
         per_30_a_39 per_40_a_49 per_50_a_59 per_60_a_69 per_70_a_79 per_80_mas
      1        50014       39637       31396       19015       10148       4885
      2       184644      141446      119102       81959       48453      25952
      3        42216       32710       23515       14118        7828       3756
      4       556818      489478      468483      325926      183070     101105
      5         5070        3781        2749        1327         739        241
      6         9268        6869        4910        2628        1104        483
      7        60363       47854       33949       18891        9158       4138
      8         8583        6101        4342        2595        1252        466
      9         3572        2769        2165        1335         614        244
      10        9883        8557        6779        3698        1682        642
      11      128691      117158      121382       90708       49434      25782
      12       71167       64102       67257       50919       28287      14575
      13      121735      104295      104556       77828       42912      21455
      14      922957      731363      722405      475989      247724     130816
      15       60978       43383       34220       21528       10726       6274
      16      200153      164583      135024       91687       57525      31188
      17      210012      181852      155038       99236       57987      30375
      18      267710      218890      189621      121767       65164      35911
      19      155437      122867       94037       58241       30155      14846
      20      110711       77515       58789       34240       17378       8851
      21      171019      142734      117537       76127       39509      20246
      22      117314      100813       86722       57464       32599      16884
      23        7226        6225        6939        3700        1532        639
      24       35367       27078       20837       11887        6288       2743
      25      156535      143256      129739       94149       56122      31047
      26      424455      352676      312310      205149      111133      58073
      27      200230      161825      139029       89786       47703      24211
      28     1183167      932944      852572      537400      270715     138673
      29      139372      112793       94330       56760       29230      13444
      30      142149      117705      104170       68214       37117      19464
      31      297718      256853      231603      152170       85688      44934
      32      162559      150113      148313      107246       63224      33115
      33      350080      280540      253357      161055       82852      45728
         per_ed_primaria per_ed_secundaria per_ed_superior per_ed_posgrado
      1           113225             24649           17680             904
      2           434283            195877          105690            7288
      3            85979             30892           20987             501
      4           851033            446077          636722           44248
      5            18602              2788            2227              28
      6            27247              7596            2690              32
      7           102154             23115           31181            1379
      8            18556             14681            3921              81
      9            15257              5830            1461              61
      10           22839              5661            5361             143
      11          258453            116043          126537           11865
      12          106490             50399           71892            6290
      13          210345             84602          120368           10554
      14         1558591            926799          997804           97384
      15          132331             65518           30069            1642
      16          469165            163573          108490            9877
      17          421731            126033          129852            3395
      18          468320            141649          228551            8731
      19          280588             60433          113117            3001
      20          238418             75145           55666            1393
      21          318878             91311          111732            3718
      22          226468             55890           63948            1763
      23            6703              4059            9100             165
      24           69619             14245           15651             150
      25          353265            141056          133768           12118
      26          761381            501867          440140           29189
      27          391109            104178          135143            7744
      28         1364959           1244974         1895668          332471
      29          227591             78289          104887            6217
      30          321487             87811           83068            5659
      31          545627            201206          312193           27462
      32          340678            133131          135512            8904
      33          503791            220976          414689           22337
         per_ed_sin_educacion per_ed_sin_info
      1                 17844           10238
      2                 56673           17057
      3                 11058            5630
      4                111703           49860
      5                  2545            1886
      6                  6874            3657
      7                 14502            5762
      8                  2037            3127
      9                  1848            1668
      10                 3437            3515
      11                36039            9771
      12                19137            6369
      13                30684            9292
      14               222981           76285
      15                35183           32571
      16                71853           29532
      17               129392           13610
      18               107699           18865
      19                72536           13869
      20               101501           12171
      21                82711           14016
      22                75637            9729
      23                  504             795
      24                13125            4125
      25                49528           16598
      26                74710           40494
      27                70766           17725
      28               111390          161781
      29                33678           21983
      30                39808           13664
      31                70664           27716
      32                58496           16978
      33                69822           27396

