% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_rbedInfo.R
\name{shiftBed}
\alias{shiftBed}
\title{Shift bed files}
\usage{
shiftBed(rbed_info, n_shift, db_setup = FALSE, collapse_matrix = NULL)
}
\arguments{
\item{rbed_info}{RbedInfoC object}

\item{n_shift}{integer.}

\item{db_setup}{logical. Whether to setup SQLite database for .bim, .fam and .frq files.}

\item{collapse_matrix}{matrix of integers. See details.}
}
\value{
RbedInfoC object, with the shifted bed file path in it.
}
\description{
Generates collapsed genotypes by shifting the bed file
(i.e. SNP1 collapsed with SNP2, SNP2 collapsed with SNP3, etc,
when \code{n_shift == 1}).
}
\details{
Collapsing matrix.
The collapse_matrix parameter allows collapsing of two genotypes in
a arbitrary way. Each genotype is represented by either 0, 1, 2, or 3:
\describe{
\item{0}{Homozygote of the minor allele.}
\item{1}{NA}
\item{2}{Heterozygote.}
\item{3}{Homozygote of the major allele.}
}

The collapsing function is implemented as a matrix lookup function, i.e.
\eqn{Collapse(S1, S2) = CollapseMatrix[S1][S2]}.

The default collapsing matrix is:

\tabular{rrrr}{
  0 \tab 0 \tab 0 \tab 0\cr
  0 \tab 1 \tab 1 \tab 1\cr
  0 \tab 1 \tab 0 \tab 3\cr
  0 \tab 1 \tab 3 \tab 3
}
}
\author{
Kaiyin Zhong, Fan Liu
}

