% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Poisson_LogLik}
\alias{Poisson_LogLik}
\title{Utility function to calculate poisson log-likelihood and derivatives
\code{Poisson_LogLik} Called to update log-likelihoods, Uses list risk matrices and person-years, Sums the log-likelihood contribution from each row}
\usage{
Poisson_LogLik(
  nthreads,
  totalnum,
  PyrC,
  R,
  Rd,
  Rdd,
  RdR,
  RddR,
  Ll,
  Lld,
  Lldd,
  debugging,
  KeepConstant
)
}
\arguments{
\item{nthreads}{number of threads available}

\item{totalnum}{total number of parameters}

\item{PyrC}{matrix of person-years and event counts}

\item{R}{risk vector}

\item{Rd}{Risk first derivative matrix}

\item{Rdd}{Risk second derivative matrix}

\item{RdR}{Risk to first derivative ratio matrix}

\item{RddR}{Risk to second derivative ratio matrix}

\item{Ll}{Log-likelihood vector}

\item{Lld}{Log-likelihood first derivative matrix}

\item{Lldd}{Log-likelihood second derivative matrix}

\item{debugging}{additional boolean for verbosity in testing}

\item{KeepConstant}{binary vector to identify constant parameters}
}
\value{
Updates matrices in place: Log-likelihood vectors/matrix
}
\description{
Utility function to calculate poisson log-likelihood and derivatives
\code{Poisson_LogLik} Called to update log-likelihoods, Uses list risk matrices and person-years, Sums the log-likelihood contribution from each row
}
