% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{Check_Trunc}
\alias{Check_Trunc}
\title{Applies time duration truncation limits to create columns for Cox model}
\usage{
Check_Trunc(df, ce, verbose = 0)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{ce}{columns to check for truncation, (t0, t1, event)}

\item{verbose}{integer valued 0-4 controlling what information is printed to the terminal. Each level includes the lower levels. 0: silent, 1: errors printed, 2: warnings printed, 3: notes printed, 4: debug information printed. Errors are situations that stop the regression, warnings are situations that assume default values that the user might not have intended, notes provide information on regression progress, and debug prints out C++ progress and intermediate results. The default level is 2 and True/False is converted to 3/0.}
}
\value{
returns the updated data and time period columns
}
\description{
\code{Check_Trunc} creates columns to use for truncation
}
\examples{
library(data.table)
df <- data.table::data.table(
  "UserID" = c(112, 114, 213, 214, 115, 116, 117),
  "Starting_Age" = c(18, 20, 18, 19, 21, 20, 18),
  "Ending_Age" = c(30, 45, 57, 47, 36, 60, 55),
  "Cancer_Status" = c(0, 0, 1, 0, 1, 0, 0)
)
# For the interval case
time1 <- "Starting_Age"
time2 <- "Ending_Age"
ce <- c("\%trunc\%", "Ending_Age")
val <- Check_Trunc(df, ce)
df <- val$df
ce <- val$ce

}
\seealso{
Other Data Cleaning Functions: 
\code{\link{Check_Dupe_Columns}()},
\code{\link{Check_Verbose}()},
\code{\link{Correct_Formula_Order}()},
\code{\link{Date_Shift}()},
\code{\link{Def_Control}()},
\code{\link{Def_Control_Guess}()},
\code{\link{Def_model_control}()},
\code{\link{Def_modelform_fix}()},
\code{\link{Joint_Multiple_Events}()},
\code{\link{Replace_Missing}()},
\code{\link{Time_Since}()},
\code{\link{factorize}()},
\code{\link{factorize_par}()},
\code{\link{gen_time_dep}()},
\code{\link{interact_them}()}
}
\concept{Data Cleaning Functions}
