% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Help_Func.R
\name{getQuantileRefactored}
\alias{getQuantileRefactored}
\title{Compute Quantile Functions for a Predictor in a GAMLSS Model}
\usage{
getQuantileRefactored(
  obj,
  term,
  quantile,
  data,
  n.points = 100,
  fixed.at = list()
)
}
\arguments{
\item{obj}{A fitted GAMLSS model object.}

\item{term}{A character string specifying the name of the predictor variable for which quantiles are computed.}

\item{quantile}{A numeric vector of probabilities (e.g., \code{c(0.25, 0.5, 0.75)}) at which to compute the quantiles.}

\item{data}{A data frame containing the dataset used in the model. This must include the predictor specified in \code{term}.}

\item{n.points}{An integer specifying the number of points at which to evaluate the quantile functions (default: 100).}

\item{fixed.at}{A named list specifying fixed values for other predictors in the dataset. If not provided,
categorical predictors are set to their most frequent levels, and numeric predictors to their median values.}
}
\value{
A list of spline functions, one for each quantile specified in \code{quantile}. Each spline function can
be evaluated at specific predictor values to obtain the corresponding quantile.
}
\description{
This function computes quantile functions for a specified predictor in a GAMLSS model, allowing
the evaluation of response quantiles (e.g., 25th, 50th, 75th percentiles) as a function of the predictor.
It is a modified version of the \code{getQuantile} function from the \strong{GAMLSS} package, with improvements to
explicitly require the dataset as an argument, avoiding reliance on global or external variables.
}
\details{
This function generates a temporary dataset by varying the specified predictor (\code{term}) over a sequence of
values while holding all other predictors constant (using values specified in \code{fixed.at}, or derived defaults).
It then computes the distribution parameters for the GAMLSS model and calculates the quantiles using the appropriate
quantile function for the distribution family.
}
\examples{
if (requireNamespace("gamlss", quietly = TRUE)) {
  library(gamlss)
  sub_df <- data.frame(
    age = seq(1, 20, length.out = 100),
    height = 50 + 2.5 * seq(1, 20, length.out = 100) + rnorm(100, 0, 5)
  )

  mdl <- gamlss(height ~ pb(age), data = sub_df, family = NO())

  quantile_function <- getQuantileRefactored(
    obj = mdl,
    term = "age",
    quantile = c(0.25, 0.5, 0.75),
    data = sub_df
  )
 }else{
 message("The 'gamlss' package is not installed. Please install it to run this example.")
 }
}
