/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.HorizontalRule;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;

public class VlineAtom
extends Atom {
    private float height;
    private float shift;
    private int n;

    public VlineAtom(int n) {
        this.n = n;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setShift(float shift) {
        this.shift = shift;
    }

    public float getWidth(TeXEnvironment env) {
        if (this.n != 0) {
            float drt = env.getTeXFont().getDefaultRuleThickness(env.getStyle());
            return drt * (float)(3 * this.n - 2);
        }
        return 0.0f;
    }

    public Box createBox(TeXEnvironment env) {
        if (this.n != 0) {
            float drt = env.getTeXFont().getDefaultRuleThickness(env.getStyle());
            HorizontalRule b = new HorizontalRule(this.height, drt, this.shift);
            StrutBox sep = new StrutBox(2.0f * drt, 0.0f, 0.0f, 0.0f);
            HorizontalBox hb = new HorizontalBox();
            for (int i = 0; i < this.n - 1; ++i) {
                hb.add(b);
                hb.add(sep);
            }
            if (this.n > 0) {
                hb.add(b);
            }
            return hb;
        }
        return new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
    }
}

