% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_TRH.R
\name{graph_TRH}
\alias{graph_TRH}
\title{Function for graphing temperature and humidity data}
\usage{
graph_TRH(mydata, Date = "Date", Temp = "Temp", RH = "RH")
}
\arguments{
\item{mydata}{A data frame containing the date, temperature, and relative humidity data.}

\item{Date}{The name of the column in mydata containing date information.}

\item{Temp}{The name of the column in mydata containing temperature data.}

\item{RH}{The name of the column in mydata containing relative humidity data.}
}
\value{
A ggplot graph of temperature and relative humidity.
}
\description{
Use this tool to produce a simple temperature and humidity plot
}
\examples{

# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 1000)

graph_TRH(mydata)



}
