% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernelEstimation.R
\name{estimateCondQuantiles}
\alias{estimateCondQuantiles}
\title{Compute kernel-based conditional quantiles}
\usage{
estimateCondQuantiles(observedX1, probsX1, matrixK3)
}
\arguments{
\item{observedX1}{a sample of observations of X1 of size n}

\item{probsX1}{a sample of probabilities at which we want to compute
the quantiles for the variable X1, of size p1}

\item{matrixK3}{a matrix of kernel values of dimension (p2 , n)
\eqn{\big(K_h(X3[i] - U3[j])\big)_{i,j}}
such as given by \code{\link{computeKernelMatrix}}.}
}
\value{
A matrix of dimensions \code{(p1,p2)} whose (i,j) entry is \eqn{\hat Q(u_1 | X_3 = x_3)}
with \eqn{u_1} = \code{probsX1[i]} and \eqn{x_3} = \code{newX3[j]},
where \code{newX3[j]} is the vector that was used to construct \code{matrixK3}.
}
\description{
This function is supposed to be used with \code{\link{computeKernelMatrix}}.
Assume that we observe a sample \eqn{(X_{i,1}, X_{i,3}), i=1, \dots, n}.
We want to estimate the conditional quantiles of \eqn{X_1} given \eqn{X_3 = x_3}
at point \eqn{u_1} using the following kernel-based estimator
\deqn{\hat Q(u_1 | X_3 = x_3) := \hat P^{(-1)}(u_1 \leq x_1 | X_3 = x_3),}
where
\deqn{\hat P(X_1 \leq x_1 | X_3 = x_3)
:= \frac{\sum_{l=1}^n 1 \{X_(l,1) \leq x_1 \} K_h(X_(l,3) - x_3)}
{\sum_{l=1}^n K_h(X_(l,3) - x_3)},}
for every \eqn{u_1} in \code{probsX1} and every \eqn{x_3} in \code{newX3}.
The \code{matrixK3} should be a matrix of the values \eqn{K_h(X_(l,3) - x_3)}
such as the one produced by
\code{\link{computeKernelMatrix}(observedX3, newX3, kernel, h)}.
}
\examples{
Y = MASS::mvrnorm(n = 100, mu = c(0,0), Sigma = cbind(c(1, 0.9), c(0.9, 1)))
matrixK = computeKernelMatrix(observedX = Y[,2] , newX = c(0, 1, 2.5),
  kernel = "Gaussian", h = 0.8)
matrixnp = estimateCondQuantiles(observedX1 = Y[,2],
  probsX1 = c(0.3, 0.5) , matrixK3 = matrixK)
matrixnp

}
