% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jacobi_etal_2012.R
\encoding{UTF-8}
\name{mergeSubpops}
\alias{mergeSubpops}
\title{Merge subpopulations}
\usage{
mergeSubpops(subpops.lst, conn.mat, beta)
}
\arguments{
\item{subpops.lst}{A list whose elements are vectors of indices for each subpopulation.  See \code{\link{subpopsVectorToList}}.}

\item{conn.mat}{A square connectivity matrix.  This matrix has
typically been normalized and made symmetric prior to using this
function.}

\item{beta}{Controls degree of splitting of connectivity matrix,
with larger values generating more subpopulations.}
}
\value{
List of the same format as subpops.lst, but with
potentially fewer subpopulations.
}
\description{
This function tries to merge random subopoulations, checking if the
result is a better soluton to the minimization problem.
}
\author{
David M. Kaplan \email{dmkaplan2000@gmail.com}
}
\references{
Jacobi, M. N., Andre, C., Doos, K., and Jonsson,
P. R. 2012. Identification of subpopulations from connectivity
matrices. Ecography, 35: 1004-1016.
}
\seealso{
See also \code{\link{optimalSplitConnMat}},
}

