% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApexGame.R
\name{apexGameValue}
\alias{apexGameValue}
\title{Compute value of a coalition for an apex game}
\usage{
apexGameValue(S, n, apexPlayer)
}
\arguments{
\item{S}{numeric vector with coalition of players}

\item{n}{represents the number of players}

\item{apexPlayer}{specifies the number of the apex player}
}
\value{
value of coalition S
}
\description{
\strong{Coalition value for an apex game:} \cr
For further information see \link{apexGame}
}
\examples{
library(CoopGame)
apexGameValue(c(1,2),3,2)

\donttest{
library(CoopGame)
apexGameValue(c(1,2,3,4),4,3)
# Output:
# [1] 1
}

}
\references{
Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 164--165
}
\author{
Alexandra Tiukkel

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
